/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.mkt.executor;

import com.alibaba.fastjson.JSONObject;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.Constants;
import com.upay.sdk.HttpClientUtils;
import com.upay.sdk.core.CipherWrapper;
import com.upay.sdk.core.response.HttpReponse;
import com.upay.sdk.exception.RequestParamException;
import com.upay.sdk.exception.ResponseDecryptException;
import com.upay.sdk.exception.UnknownException;
import com.upay.sdk.executer.Executer;
import com.upay.sdk.executer.ResultListener;
import com.upay.sdk.mkt.builder.DiscountApplyBuilder;
import com.upay.sdk.mkt.builder.DiscountQueryBuilder;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiscountExecutor
extends Executer {
    static final Logger LOGGER = LoggerFactory.getLogger(DiscountExecutor.class);

    public void apply(DiscountApplyBuilder builder, ResultListener listener) throws RequestParamException, ResponseDecryptException {
        String url = ConfigurationUtils.getMktDiscountApplyUrl();
        try {
            HttpReponse response = HttpClientUtils.sdkPost(url, builder);
            Object decryptResponse = response.getDecryptResponse();
            if (!(decryptResponse instanceof JSONObject)) {
                throw new RuntimeException("MktDiscountApply server response error,response object not a json!");
            }
            JSONObject responseJson = (JSONObject)decryptResponse;
            if (response.success()) {
                String status = responseJson.getString(Constants.STATUS);
                if (StringUtils.isBlank((CharSequence)status) || Constants.SUCCESS.equals(status)) {
                    listener.success(responseJson);
                } else {
                    listener.failure(responseJson);
                }
            } else {
                LOGGER.error("MktDiscountApply request response error,errorCode:{}", (Object)response.getResponseCode());
                listener.failure(responseJson);
            }
        }
        catch (RequestParamException e) {
            LOGGER.error("MktDiscountApply param error request url:[{}]", (Object)url, (Object)e);
            throw e;
        }
        catch (ResponseDecryptException e) {
            LOGGER.error("MktDiscountApply response decrypt error request url:[{}] ", (Object)url, (Object)e);
            throw e;
        }
        catch (Exception e) {
            LOGGER.error("MktDiscountApply unknown error request url:[{}]", (Object)url, (Object)e);
            throw new UnknownException(e);
        }
    }

    public void query(DiscountQueryBuilder builder, ResultListener listener) throws RequestParamException, ResponseDecryptException {
        String url = ConfigurationUtils.getMktDiscountQueryUrl();
        try {
            HttpReponse response = HttpClientUtils.sdkPost(url, builder);
            Object decryptResponse = response.getDecryptResponse();
            if (!(decryptResponse instanceof JSONObject)) {
                throw new RuntimeException("MktDiscountQuery server response error,response object not a json!");
            }
            JSONObject responseJson = (JSONObject)decryptResponse;
            if (response.success()) {
                String status = responseJson.getString(Constants.STATUS);
                if (StringUtils.isBlank((CharSequence)status) || Constants.SUCCESS.equals(status)) {
                    listener.success(responseJson);
                } else {
                    listener.failure(responseJson);
                }
            } else {
                LOGGER.error("MktDiscountQuery request response error,errorCode:{}", (Object)response.getResponseCode());
                listener.failure(responseJson);
            }
        }
        catch (RequestParamException e) {
            LOGGER.error("MktDiscountQuery param error request url:[{}]", (Object)url, (Object)e);
            throw e;
        }
        catch (ResponseDecryptException e) {
            LOGGER.error("MktDiscountQuery response decrypt error request url:[{}] ", (Object)url, (Object)e);
            throw e;
        }
        catch (Exception e) {
            LOGGER.error("MktDiscountQuery unknown error request url:[{}]", (Object)url, (Object)e);
            throw new UnknownException(e);
        }
    }

    public JSONObject decrypt(JSONObject responseData) {
        return CipherWrapper.bothDecryptWrap(responseData);
    }
}

