/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.icc.v_3.builder;

import com.alibaba.fastjson.JSONObject;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.RSAUtils;
import com.upay.sdk.SignUtils;
import com.upay.sdk.builder.BuilderSupport;
import com.upay.sdk.core.CipherWrapper;
import com.upay.sdk.exception.UnknownException;
import org.apache.commons.lang3.StringUtils;

public class BrowseBackFillBuilder
extends BuilderSupport {
    private String merchantId;
    private String requestId;
    private String payName;
    private String payPhone;
    private String payAddress;
    private String payEmail;
    private String productName;
    private String receiveName;
    private String receivePhone;
    private String receiveAddress;
    private String receiveEmail;
    private String expressCompany;
    private String expressNumber;
    private String partnerId;

    public BrowseBackFillBuilder(String merchantId) {
        this.merchantId = merchantId;
    }

    public BrowseBackFillBuilder setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public BrowseBackFillBuilder setPayName(String payName) {
        this.payName = payName;
        return this;
    }

    public BrowseBackFillBuilder setPayPhone(String payPhone) {
        this.payPhone = payPhone;
        return this;
    }

    public BrowseBackFillBuilder setPayAddress(String payAddress) {
        this.payAddress = payAddress;
        return this;
    }

    public BrowseBackFillBuilder setPayEmail(String payEmail) {
        this.payEmail = payEmail;
        return this;
    }

    public BrowseBackFillBuilder setProductName(String productName) {
        this.productName = productName;
        return this;
    }

    public BrowseBackFillBuilder setReceiveName(String receiveName) {
        this.receiveName = receiveName;
        return this;
    }

    public BrowseBackFillBuilder setReceivePhone(String receivePhone) {
        this.receivePhone = receivePhone;
        return this;
    }

    public BrowseBackFillBuilder setReceiveAddress(String receiveAddress) {
        this.receiveAddress = receiveAddress;
        return this;
    }

    public BrowseBackFillBuilder setReceiveEmail(String receiveEmail) {
        this.receiveEmail = receiveEmail;
        return this;
    }

    public BrowseBackFillBuilder setExpressCompany(String expressCompany) {
        this.expressCompany = expressCompany;
        return this;
    }

    public BrowseBackFillBuilder setExpressNumber(String expressNumber) {
        this.expressNumber = expressNumber;
        return this;
    }

    public BrowseBackFillBuilder setPartnerId(String partnerId) {
        this.partnerId = partnerId;
        return this;
    }

    @Override
    protected String orderGenerateHmac() {
        return SignUtils.signMd5(super.orderGenerateHmac(), ConfigurationUtils.getHmacKey(StringUtils.isBlank((CharSequence)this.partnerId) ? this.merchantId : this.partnerId));
    }

    public JSONObject bothEncryptBuild() {
        JSONObject json = super.assembleBuild();
        try {
            json.put("hmac", (Object)this.bothOrderGenerateHmac());
        }
        catch (Exception e) {
            throw new UnknownException(e);
        }
        if (StringUtils.isNotBlank((CharSequence)this.partnerId)) {
            return CipherWrapper.bothEncryptWrap(this.merchantId, this.partnerId, json);
        }
        return CipherWrapper.bothEncryptWrap(this.merchantId, json);
    }

    protected byte[] bothOrderGenerateHmac() throws Exception {
        return RSAUtils.encryptSHA(super.orderGenerateHmac().getBytes("UTF-8"));
    }
}

