/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.hg.builder;

import com.alibaba.fastjson.JSONObject;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.SignUtils;
import com.upay.sdk.builder.BuilderSupport;
import com.upay.sdk.entity.CustomsInfo;
import com.upay.sdk.entity.Payer;
import com.upay.sdk.entity.ProductDetail;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public final class OrderBuilder
extends BuilderSupport {
    private String merchantId;
    private String requestId;
    private String orderAmount;
    private String orderCurrency;
    private String notifyUrl;
    private String remark;
    private Payer payer;
    private List<ProductDetail> productDetails = new LinkedList<ProductDetail>();
    private List<CustomsInfo> customsInfos = new LinkedList<CustomsInfo>();

    public OrderBuilder(String merchantId) {
        this.merchantId = merchantId;
    }

    public OrderBuilder setOrderAmount(String orderAmount) {
        this.orderAmount = orderAmount;
        return this;
    }

    public OrderBuilder setOrderCurrency(String orderCurrency) {
        this.orderCurrency = orderCurrency;
        return this;
    }

    public OrderBuilder setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public OrderBuilder setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
        return this;
    }

    public OrderBuilder setRemark(String remark) {
        this.remark = remark;
        return this;
    }

    public OrderBuilder setPayer(Payer payer) {
        this.payer = payer;
        return this;
    }

    public void setProductDetails(List<ProductDetail> productDetails) {
        this.productDetails = productDetails;
    }

    public void setCustomsInfos(List<CustomsInfo> customsInfos) {
        this.customsInfos = customsInfos;
    }

    public OrderBuilder addProductDetail(ProductDetail productDetail) {
        this.productDetails.add(productDetail);
        return this;
    }

    public OrderBuilder addCustomsInfo(CustomsInfo customsInfo) {
        this.customsInfos.add(customsInfo);
        return this;
    }

    public JSONObject build() {
        JSONObject json = super.build(this.merchantId);
        if (StringUtils.isNotBlank((CharSequence)this.requestId)) {
            json.put("requestId", (Object)this.requestId);
        }
        if (StringUtils.isNotBlank((CharSequence)this.orderAmount)) {
            json.put("orderAmount", (Object)this.orderAmount);
        }
        if (StringUtils.isNotBlank((CharSequence)this.orderCurrency)) {
            json.put("orderCurrency", (Object)this.orderCurrency);
        }
        if (StringUtils.isNotBlank((CharSequence)this.notifyUrl)) {
            json.put("notifyUrl", (Object)this.notifyUrl);
        }
        if (StringUtils.isNotBlank((CharSequence)this.remark)) {
            json.put("remark", (Object)this.remark);
        }
        json.put("productDetails", this.productDetails);
        json.put("customsInfos", this.customsInfos);
        json.put("payer", (Object)this.payer);
        json.put("hmac", (Object)this.generateHmac());
        return json;
    }

    private String generateHmac() {
        StringBuilder hmacSource = new StringBuilder();
        hmacSource.append(StringUtils.defaultString((String)this.merchantId)).append(StringUtils.defaultString((String)this.requestId, (String)"")).append(StringUtils.defaultString((String)this.orderAmount, (String)"")).append(StringUtils.defaultString((String)this.orderCurrency, (String)"")).append(StringUtils.defaultString((String)this.notifyUrl, (String)"")).append(StringUtils.defaultString((String)this.remark, (String)""));
        if (this.productDetails != null) {
            for (ProductDetail productDetail : this.productDetails) {
                hmacSource.append(StringUtils.defaultString((String)productDetail.getName())).append(ObjectUtils.defaultIfNull((Object)productDetail.getQuantity(), (Object)"")).append(ObjectUtils.defaultIfNull((Object)productDetail.getAmount(), (Object)"")).append(StringUtils.defaultString((String)productDetail.getReceiver())).append(StringUtils.defaultString((String)productDetail.getDescription()));
            }
        }
        if (this.payer != null) {
            hmacSource.append(StringUtils.defaultString((String)this.payer.getName())).append(StringUtils.defaultString((String)this.payer.getIdType())).append(StringUtils.defaultString((String)this.payer.getIdNum())).append(StringUtils.defaultString((String)this.payer.getCustomerId())).append(StringUtils.defaultString((String)this.payer.getBankCardNum())).append(StringUtils.defaultString((String)this.payer.getPhoneNum())).append(StringUtils.defaultString((String)this.payer.getEmail())).append(StringUtils.defaultString((String)this.payer.getNationality()));
        }
        if (this.customsInfos != null) {
            for (CustomsInfo customsInfo : this.customsInfos) {
                hmacSource.append(StringUtils.defaultString((String)customsInfo.getCustomsChannel())).append(ObjectUtils.defaultIfNull((Object)customsInfo.getAmount(), (Object)"")).append(ObjectUtils.defaultIfNull((Object)customsInfo.getFreight(), (Object)"")).append(ObjectUtils.defaultIfNull((Object)customsInfo.getGoodsAmount(), (Object)"")).append(ObjectUtils.defaultIfNull((Object)customsInfo.getTax(), (Object)"")).append(ObjectUtils.defaultIfNull((Object)customsInfo.getInsuredAmount(), (Object)"")).append((String)ObjectUtils.defaultIfNull((Object)customsInfo.getCommerceCode(), (Object)"")).append((String)ObjectUtils.defaultIfNull((Object)customsInfo.getCommerceName(), (Object)""));
            }
        }
        System.out.println("===========" + hmacSource.toString());
        return SignUtils.signMd5(hmacSource.toString(), ConfigurationUtils.getHmacKey(this.merchantId));
    }
}

