/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.enjoy.merchant.executer;

import com.alibaba.fastjson.JSONObject;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.Constants;
import com.upay.sdk.HttpClientUtils;
import com.upay.sdk.core.response.HttpReponse;
import com.upay.sdk.enjoy.merchant.builder.WalletPasswordValidateBuilder;
import com.upay.sdk.enjoy.merchant.builder.WalletPasswordValidateQueryBuilder;
import com.upay.sdk.exception.RequestParamException;
import com.upay.sdk.exception.ResponseDecryptException;
import com.upay.sdk.exception.UnknownException;
import com.upay.sdk.executer.Executer;
import com.upay.sdk.executer.ResultListener;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WalletPasswordValidateExecuter
extends Executer {
    private static final Logger LOGGER = LoggerFactory.getLogger(WalletPasswordValidateExecuter.class);

    public void create(WalletPasswordValidateBuilder builder, ResultListener resultListener) throws RequestParamException, ResponseDecryptException {
        String url = ConfigurationUtils.getEnjoyMerchantWalletPasswordValidateCreateUrl();
        try {
            HttpReponse response = HttpClientUtils.sdkPost(url, builder);
            Object decryptResponse = response.getDecryptResponse();
            if (!(decryptResponse instanceof JSONObject)) {
                throw new RuntimeException("server response error,response object not a json!");
            }
            JSONObject responseJson = (JSONObject)decryptResponse;
            if (response.success()) {
                String status = responseJson.getString(Constants.STATUS);
                if (StringUtils.isBlank((CharSequence)status) || Constants.SUCCESS.equals(status)) {
                    resultListener.success(responseJson);
                } else {
                    resultListener.failure(responseJson);
                }
            } else {
                LOGGER.error("create request response error,errorCode:{}", (Object)response.getResponseCode());
                resultListener.failure(responseJson);
            }
        }
        catch (RequestParamException e) {
            LOGGER.error("create request url:[{}]", (Object)url, (Object)e);
            throw e;
        }
        catch (ResponseDecryptException e) {
            LOGGER.error("create request url:[{}] ", (Object)url, (Object)e);
            throw e;
        }
        catch (Exception e) {
            LOGGER.error("create request url:[{}]", (Object)url, (Object)e);
            throw new UnknownException(e);
        }
    }

    public void query(WalletPasswordValidateQueryBuilder builder, ResultListener resultListener) throws RequestParamException, ResponseDecryptException {
        String url = ConfigurationUtils.getEnjoyMerchantWalletPasswordValidateQueryUrl();
        try {
            HttpReponse response = HttpClientUtils.sdkPost(url, builder);
            Object decryptResponse = response.getDecryptResponse();
            if (!(decryptResponse instanceof JSONObject)) {
                throw new RuntimeException("server response error,response object not a json!");
            }
            JSONObject responseJson = (JSONObject)decryptResponse;
            if (response.success()) {
                String status = responseJson.getString(Constants.STATUS);
                if (StringUtils.isBlank((CharSequence)status) || Constants.SUCCESS.equals(status)) {
                    resultListener.success(responseJson);
                } else {
                    resultListener.failure(responseJson);
                }
            } else {
                LOGGER.error("query request response error,errorCode:{}", (Object)response.getResponseCode());
                resultListener.failure(responseJson);
            }
        }
        catch (RequestParamException e) {
            LOGGER.error("query request url:[{}]", (Object)url, (Object)e);
            throw e;
        }
        catch (ResponseDecryptException e) {
            LOGGER.error("query request url:[{}] ", (Object)url, (Object)e);
            throw e;
        }
        catch (Exception e) {
            LOGGER.error("query request url:[{}]", (Object)url, (Object)e);
            throw new UnknownException(e);
        }
    }
}

