/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.enjoy.merchant.builder;

import com.alibaba.fastjson.JSONObject;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.RSAUtils;
import com.upay.sdk.SignUtils;
import com.upay.sdk.builder.BuilderSupportWrap;
import com.upay.sdk.core.CipherWrapper;
import com.upay.sdk.exception.UnknownException;
import org.apache.commons.lang3.StringUtils;

public class MerchantWalletSilenceRescindBuilder
extends BuilderSupportWrap {
    private String merchantId;
    private String partnerId;
    private String requestId;

    public MerchantWalletSilenceRescindBuilder(String merchantId) {
        this.merchantId = merchantId;
    }

    public MerchantWalletSilenceRescindBuilder(String merchantId, String partnerId) {
        this.merchantId = merchantId;
        this.partnerId = partnerId;
    }

    @Override
    public String getMerchantId() {
        return this.merchantId;
    }

    public MerchantWalletSilenceRescindBuilder setMerchantId(String merchantId) {
        this.merchantId = merchantId;
        return this;
    }

    @Override
    public String getPartnerId() {
        return this.partnerId;
    }

    public MerchantWalletSilenceRescindBuilder setPartnerId(String partnerId) {
        this.partnerId = partnerId;
        return this;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public MerchantWalletSilenceRescindBuilder setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public JSONObject bothEncryptBuild() {
        JSONObject json = super.assembleBuild();
        try {
            json.put("hmac", (Object)this.bothOrderGenerateHmac());
        }
        catch (Exception e) {
            throw new UnknownException(e);
        }
        if (StringUtils.isNotBlank((CharSequence)this.partnerId)) {
            return CipherWrapper.bothEncryptWrap(this.merchantId, this.partnerId, json);
        }
        return CipherWrapper.bothEncryptWrap(this.merchantId, json);
    }

    protected byte[] bothOrderGenerateHmac() throws Exception {
        return RSAUtils.encryptSHA(super.orderGenerateHmac().getBytes("UTF-8"));
    }

    public JSONObject encryptBuild() {
        JSONObject json = super.assembleBuild();
        json.put("hmac", (Object)this.orderGenerateHmac());
        return CipherWrapper.encryptWrap(this.merchantId, json);
    }

    @Override
    protected String orderGenerateHmac() {
        String orderGenerateHmac = super.orderGenerateHmac();
        return SignUtils.signMd5(orderGenerateHmac, ConfigurationUtils.getHmacKey(this.merchantId));
    }
}

