/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.customerinforeport.builder;

import com.alibaba.fastjson.JSONObject;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.RSAUtils;
import com.upay.sdk.SignUtils;
import com.upay.sdk.builder.BuilderSupport;
import com.upay.sdk.core.CipherWrapper;
import com.upay.sdk.entity.ForeignCustomerInfoReport;
import com.upay.sdk.exception.UnknownException;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public final class ForeignCustomerInfoReportBuilder
extends BuilderSupport {
    private String merchantId;
    private String requestId;
    private String channelType;
    private List<ForeignCustomerInfoReport> customsInfos = new LinkedList<ForeignCustomerInfoReport>();

    public ForeignCustomerInfoReportBuilder(String merchantId) {
        this.merchantId = merchantId;
    }

    public ForeignCustomerInfoReportBuilder setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public ForeignCustomerInfoReportBuilder setChannelType(String channelType) {
        this.channelType = channelType;
        return this;
    }

    public ForeignCustomerInfoReportBuilder addCustomsInfo(ForeignCustomerInfoReport customsInfo) {
        this.customsInfos.add(customsInfo);
        return this;
    }

    public JSONObject build() {
        JSONObject json = super.build(this.merchantId);
        if (StringUtils.isNotBlank((CharSequence)this.requestId)) {
            json.put("requestId", (Object)this.requestId);
        }
        if (StringUtils.isNotBlank((CharSequence)this.channelType)) {
            json.put("channelType", (Object)this.channelType);
        }
        json.put("customsInfos", this.customsInfos);
        json.put("hmac", (Object)this.generateHmac());
        return json;
    }

    private String generateHmac() {
        StringBuilder hmacSource = new StringBuilder();
        hmacSource.append(StringUtils.defaultString((String)this.merchantId)).append(StringUtils.defaultString((String)this.requestId, (String)"")).append(StringUtils.defaultString((String)this.channelType, (String)""));
        if (this.customsInfos != null) {
            for (ForeignCustomerInfoReport customsInfo : this.customsInfos) {
                hmacSource.append(StringUtils.defaultString((String)customsInfo.getEntName())).append(StringUtils.defaultString((String)customsInfo.getCustCode(), (String)"")).append(StringUtils.defaultString((String)customsInfo.getCountryCode(), (String)"")).append(StringUtils.defaultString((String)customsInfo.getBusinessPlaceCode(), (String)"")).append(StringUtils.defaultString((String)customsInfo.getIndustryAttribute(), (String)"")).append(StringUtils.defaultString((String)customsInfo.getEconomiesType(), (String)"")).append(ObjectUtils.defaultIfNull((Object)customsInfo.getSpecialEconomicZone(), (Object)false)).append(StringUtils.defaultString((String)customsInfo.getSpecialEconomicZoneEntType(), (String)"")).append(StringUtils.defaultString((String)customsInfo.getCustomerAddress(), (String)"")).append(StringUtils.defaultString((String)customsInfo.getCustomerContact(), (String)"")).append(StringUtils.defaultString((String)customsInfo.getCustomerContactTelephone(), (String)"")).append(StringUtils.defaultString((String)customsInfo.getPostalCode(), (String)""));
            }
        }
        return SignUtils.signMd5(hmacSource.toString(), ConfigurationUtils.getHmacKey(this.merchantId));
    }

    public JSONObject bothEncryptBuild() {
        JSONObject json = super.assembleBuild();
        try {
            json.put("hmac", (Object)this.bothOrderGenerateHmac());
        }
        catch (Exception e) {
            throw new UnknownException(e);
        }
        return CipherWrapper.bothEncryptWrap(this.merchantId, json);
    }

    protected byte[] bothOrderGenerateHmac() throws Exception {
        return RSAUtils.encryptSHA(super.orderGenerateHmac().getBytes("UTF-8"));
    }
}

