/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.currencyexchange.builder;

import com.alibaba.fastjson.JSONObject;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.RSAUtils;
import com.upay.sdk.SignUtils;
import com.upay.sdk.builder.BuilderSupport;
import com.upay.sdk.core.CipherWrapper;
import com.upay.sdk.exception.UnknownException;

public class PaymentAccountBuilder
extends BuilderSupport {
    private String merchantId;
    private String accountType;
    private String bankName;
    private String bankAddress;
    private String swift;
    private String accountName;
    private String accountNo;
    private String payeeAddress;
    private String currency;
    private String payeeType;
    private String nation;
    private String area;
    private String payeeName;
    private String address;
    private String contractPath;
    private String fileName;
    private String callBackUrl;

    public PaymentAccountBuilder(String merchantId) {
        this.merchantId = merchantId;
    }

    @Override
    protected String orderGenerateHmac() {
        return SignUtils.signMd5(super.orderGenerateHmac(), ConfigurationUtils.getHmacKey(this.merchantId));
    }

    public JSONObject bothEncryptBuild() {
        JSONObject json = super.assembleBuild();
        try {
            json.put("hmac", (Object)this.bothOrderGenerateHmac());
        }
        catch (Exception e) {
            throw new UnknownException(e);
        }
        return CipherWrapper.bothEncryptWrap(this.merchantId, json);
    }

    protected byte[] bothOrderGenerateHmac() throws Exception {
        return RSAUtils.encryptSHA(super.orderGenerateHmac().getBytes("UTF-8"));
    }

    public PaymentAccountBuilder setMerchantId(String merchantId) {
        this.merchantId = merchantId;
        return this;
    }

    public PaymentAccountBuilder setAccountType(String accountType) {
        this.accountType = accountType;
        return this;
    }

    public PaymentAccountBuilder setBankName(String bankName) {
        this.bankName = bankName;
        return this;
    }

    public PaymentAccountBuilder setBankAddress(String bankAddress) {
        this.bankAddress = bankAddress;
        return this;
    }

    public PaymentAccountBuilder setSwift(String swift) {
        this.swift = swift;
        return this;
    }

    public PaymentAccountBuilder setAccountName(String accountName) {
        this.accountName = accountName;
        return this;
    }

    public PaymentAccountBuilder setAccountNo(String accountNo) {
        this.accountNo = accountNo;
        return this;
    }

    public PaymentAccountBuilder setPayeeAddress(String payeeAddress) {
        this.payeeAddress = payeeAddress;
        return this;
    }

    public PaymentAccountBuilder setCurrency(String currency) {
        this.currency = currency;
        return this;
    }

    public PaymentAccountBuilder setPayeeType(String payeeType) {
        this.payeeType = payeeType;
        return this;
    }

    public PaymentAccountBuilder setNation(String nation) {
        this.nation = nation;
        return this;
    }

    public PaymentAccountBuilder setArea(String area) {
        this.area = area;
        return this;
    }

    public PaymentAccountBuilder setPayeeName(String payeeName) {
        this.payeeName = payeeName;
        return this;
    }

    public PaymentAccountBuilder setAddress(String address) {
        this.address = address;
        return this;
    }

    public PaymentAccountBuilder setContractPath(String contractPath) {
        this.contractPath = contractPath;
        return this;
    }

    public PaymentAccountBuilder setFileName(String fileName) {
        this.fileName = fileName;
        return this;
    }

    public PaymentAccountBuilder setCallBackUrl(String callBackUrl) {
        this.callBackUrl = callBackUrl;
        return this;
    }

    public String getMerchantId() {
        return this.merchantId;
    }

    public String getAccountType() {
        return this.accountType;
    }

    public String getBankName() {
        return this.bankName;
    }

    public String getBankAddress() {
        return this.bankAddress;
    }

    public String getSwift() {
        return this.swift;
    }

    public String getAccountName() {
        return this.accountName;
    }

    public String getAccountNo() {
        return this.accountNo;
    }

    public String getPayeeAddress() {
        return this.payeeAddress;
    }

    public String getCurrency() {
        return this.currency;
    }

    public String getPayeeType() {
        return this.payeeType;
    }

    public String getNation() {
        return this.nation;
    }

    public String getArea() {
        return this.area;
    }

    public String getPayeeName() {
        return this.payeeName;
    }

    public String getAddress() {
        return this.address;
    }

    public String getContractPath() {
        return this.contractPath;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getCallBackUrl() {
        return this.callBackUrl;
    }
}

