/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.crypto.utils;

import com.upay.sdk.crypto.utils.StrBuilder;
import java.io.Closeable;
import java.lang.reflect.Array;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Arrays;
import java.util.regex.Pattern;

public class CryptoUtils {
    private static final char C_BACKSLASH = '\\';
    private static final char C_DELIM_START = '{';
    private static final String EMPTY_JSON = "{}";
    public static final Charset CHARSET_UTF_8 = Charset.forName("UTF-8");
    public static final String NULL = "null";
    public static final String EMPTY = "";
    public static final int INDEX_NOT_FOUND = -1;
    public static final Pattern HEX = Pattern.compile("^[a-fA-F0-9]+$");
    private static final char[] DIGITS_LOWER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final char[] DIGITS_UPPER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static Charset charset(String charsetName) throws UnsupportedCharsetException {
        return charsetName == null || charsetName.trim().isEmpty() ? Charset.defaultCharset() : Charset.forName(charsetName);
    }

    public static byte[] bytes(CharSequence str, Charset charset) {
        if (str == null) {
            return null;
        }
        if (null == charset) {
            return str.toString().getBytes();
        }
        return str.toString().getBytes(charset);
    }

    public static String encodeHexStr(byte[] data) {
        return CryptoUtils.encodeHexStr(data, true);
    }

    public static String encodeHexStr(byte[] data, boolean toLowerCase) {
        return CryptoUtils.encodeHexStr(data, toLowerCase ? DIGITS_LOWER : DIGITS_UPPER);
    }

    public static byte[] decodeHex(String hexStr) {
        return CryptoUtils.decodeHex((CharSequence)hexStr);
    }

    public static byte[] decodeHex(CharSequence hexData) {
        if (hexData == null || hexData.length() == 0) {
            return null;
        }
        int len = (hexData = CryptoUtils.cleanBlank(hexData)).length();
        if ((len & 1) != 0) {
            hexData = "0" + hexData;
            len = hexData.length();
        }
        byte[] out = new byte[len >> 1];
        int i = 0;
        int j = 0;
        while (j < len) {
            int f = CryptoUtils.toDigit(hexData.charAt(j), j) << 4;
            f |= CryptoUtils.toDigit(hexData.charAt(++j), j);
            ++j;
            out[i] = (byte)(f & 0xFF);
            ++i;
        }
        return out;
    }

    public static BigInteger toBigInteger(String hexStr) {
        if (null == hexStr) {
            return null;
        }
        return new BigInteger(hexStr, 16);
    }

    public static byte[] HexToByte(String hexStr) {
        byte[] digest = new byte[hexStr.length() / 2];
        for (int i = 0; i < digest.length; ++i) {
            String byteString = hexStr.substring(2 * i, 2 * i + 2);
            int byteValue = Integer.parseInt(byteString, 16);
            digest[i] = (byte)byteValue;
        }
        return digest;
    }

    public static String format(String hexStr) {
        int length = hexStr.length();
        StringBuilder builder = new StringBuilder(length + length / 2);
        builder.append(hexStr.charAt(0)).append(hexStr.charAt(1));
        for (int i = 2; i < length - 1; i += 2) {
            builder.append(' ').append(hexStr.charAt(i)).append(hexStr.charAt(i + 1));
        }
        return builder.toString();
    }

    private static String encodeHexStr(byte[] data, char[] toDigits) {
        return new String(CryptoUtils.encodeHex(data, toDigits));
    }

    private static char[] encodeHex(byte[] data, char[] toDigits) {
        int len = data.length;
        char[] out = new char[len << 1];
        int j = 0;
        for (int i = 0; i < len; ++i) {
            out[j++] = toDigits[(0xF0 & data[i]) >>> 4];
            out[j++] = toDigits[0xF & data[i]];
        }
        return out;
    }

    private static int toDigit(char ch, int index) {
        int digit = Character.digit(ch, 16);
        if (digit < 0) {
            throw new RuntimeException("Illegal hexadecimal character " + ch + " at index " + index);
        }
        return digit;
    }

    public static String str(Object obj, Charset charset) {
        if (null == obj) {
            return null;
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof byte[]) {
            return CryptoUtils.str((byte[])obj, charset);
        }
        if (obj instanceof Byte[]) {
            return CryptoUtils.str((Byte[])obj, charset);
        }
        if (obj instanceof ByteBuffer) {
            return CryptoUtils.str((ByteBuffer)obj, charset);
        }
        if (CryptoUtils.isArray(obj)) {
            return CryptoUtils.toString(obj);
        }
        return obj.toString();
    }

    public static String str(byte[] bytes, String charset) {
        return CryptoUtils.str(bytes, charset == null || charset.trim().isEmpty() ? Charset.defaultCharset() : Charset.forName(charset));
    }

    public static String str(byte[] data, Charset charset) {
        if (data == null) {
            return null;
        }
        if (null == charset) {
            return new String(data);
        }
        return new String(data, charset);
    }

    public static String str(Byte[] bytes, String charset) {
        return CryptoUtils.str(bytes, charset == null || charset.trim().isEmpty() ? Charset.defaultCharset() : Charset.forName(charset));
    }

    public static String str(Byte[] data, Charset charset) {
        if (data == null) {
            return null;
        }
        byte[] bytes = new byte[data.length];
        for (int i = 0; i < data.length; ++i) {
            Byte dataByte = data[i];
            bytes[i] = null == dataByte ? -1 : (int)dataByte.byteValue();
        }
        return CryptoUtils.str(bytes, charset);
    }

    public static String str(ByteBuffer data, String charset) {
        if (data == null) {
            return null;
        }
        return CryptoUtils.str(data, Charset.forName(charset));
    }

    public static String str(ByteBuffer data, Charset charset) {
        if (null == charset) {
            charset = Charset.defaultCharset();
        }
        return charset.decode(data).toString();
    }

    public static String str(CharSequence cs) {
        return null == cs ? null : cs.toString();
    }

    public static String utf8Str(Object obj) {
        return CryptoUtils.str(obj, CHARSET_UTF_8);
    }

    public static boolean isBlankChar(char c) {
        return CryptoUtils.isBlankChar((int)c);
    }

    public static boolean isBlankChar(int c) {
        return Character.isWhitespace(c) || Character.isSpaceChar(c) || c == 65279 || c == 8234 || c == 0;
    }

    public static String cleanBlank(CharSequence str) {
        if (str == null) {
            return null;
        }
        int len = str.length();
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (CryptoUtils.isBlankChar(c)) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    public static boolean isArray(Object obj) {
        return null != obj && obj.getClass().isArray();
    }

    public static String toString(Object obj) {
        if (null == obj) {
            return null;
        }
        if (obj instanceof long[]) {
            return Arrays.toString((long[])obj);
        }
        if (obj instanceof int[]) {
            return Arrays.toString((int[])obj);
        }
        if (obj instanceof short[]) {
            return Arrays.toString((short[])obj);
        }
        if (obj instanceof char[]) {
            return Arrays.toString((char[])obj);
        }
        if (obj instanceof byte[]) {
            return Arrays.toString((byte[])obj);
        }
        if (obj instanceof boolean[]) {
            return Arrays.toString((boolean[])obj);
        }
        if (obj instanceof float[]) {
            return Arrays.toString((float[])obj);
        }
        if (obj instanceof double[]) {
            return Arrays.toString((double[])obj);
        }
        if (CryptoUtils.isArray(obj)) {
            try {
                return Arrays.deepToString((Object[])obj);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return obj.toString();
    }

    public static <T> boolean isEmpty(T[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isSubEquals(CharSequence str1, int start1, CharSequence str2, int start2, int length, boolean ignoreCase) {
        if (null == str1 || null == str2) {
            return false;
        }
        return str1.toString().regionMatches(ignoreCase, start1, str2.toString(), start2, length);
    }

    public static int indexOf(CharSequence str, CharSequence searchStr, int fromIndex, boolean ignoreCase) {
        int endLimit;
        if (str == null || searchStr == null) {
            return -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (fromIndex > (endLimit = str.length() - searchStr.length() + 1)) {
            return -1;
        }
        if (searchStr.length() == 0) {
            return fromIndex;
        }
        if (!ignoreCase) {
            return str.toString().indexOf(searchStr.toString(), fromIndex);
        }
        for (int i = fromIndex; i < endLimit; ++i) {
            if (!CryptoUtils.isSubEquals(str, i, searchStr, 0, searchStr.length(), true)) continue;
            return i;
        }
        return -1;
    }

    public static String format(String strPattern, Object ... argArray) {
        if (strPattern == null || strPattern.trim().isEmpty() || argArray == null || argArray.length == 0) {
            return strPattern;
        }
        int strPatternLength = strPattern.length();
        StringBuilder sbuf = new StringBuilder(strPatternLength + 50);
        int handledPosition = 0;
        for (int argIndex = 0; argIndex < argArray.length; ++argIndex) {
            int delimIndex = strPattern.indexOf(EMPTY_JSON, handledPosition);
            if (delimIndex == -1) {
                if (handledPosition == 0) {
                    return strPattern;
                }
                sbuf.append(strPattern, handledPosition, strPatternLength);
                return sbuf.toString();
            }
            if (delimIndex > 0 && strPattern.charAt(delimIndex - 1) == '\\') {
                if (delimIndex > 1 && strPattern.charAt(delimIndex - 2) == '\\') {
                    sbuf.append(strPattern, handledPosition, delimIndex - 1);
                    sbuf.append(CryptoUtils.utf8Str(argArray[argIndex]));
                    handledPosition = delimIndex + 2;
                    continue;
                }
                --argIndex;
                sbuf.append(strPattern, handledPosition, delimIndex - 1);
                sbuf.append('{');
                handledPosition = delimIndex + 1;
                continue;
            }
            sbuf.append(strPattern, handledPosition, delimIndex);
            sbuf.append(CryptoUtils.utf8Str(argArray[argIndex]));
            handledPosition = delimIndex + 2;
        }
        sbuf.append(strPattern, handledPosition, strPattern.length());
        return sbuf.toString();
    }

    public static String replace(CharSequence str, CharSequence searchStr, CharSequence replacement) {
        return CryptoUtils.replace(str, 0, searchStr, replacement, false);
    }

    public static String replace(CharSequence str, int fromIndex, CharSequence searchStr, CharSequence replacement, boolean ignoreCase) {
        int index;
        if (str == null || str.length() == 0 || searchStr == null || searchStr.length() == 0) {
            return CryptoUtils.str(str);
        }
        if (null == replacement) {
            replacement = EMPTY;
        }
        int strLength = str.length();
        int searchStrLength = searchStr.length();
        if (fromIndex > strLength) {
            return CryptoUtils.str(str);
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        StrBuilder result = StrBuilder.create(strLength + 16);
        if (0 != fromIndex) {
            result.append(str.subSequence(0, fromIndex));
        }
        int preIndex = fromIndex;
        while ((index = CryptoUtils.indexOf(str, searchStr, preIndex, ignoreCase)) > -1) {
            result.append(str.subSequence(preIndex, index));
            result.append(replacement);
            preIndex = index + searchStrLength;
        }
        if (preIndex < strLength) {
            result.append(str.subSequence(preIndex, strLength));
        }
        return result.toString();
    }

    public static String replace(CharSequence str, int startInclude, int endExclude, char replacedChar) {
        if (str == null || str.length() == 0) {
            return CryptoUtils.str(str);
        }
        int strLength = str.length();
        if (startInclude > strLength) {
            return CryptoUtils.str(str);
        }
        if (endExclude > strLength) {
            endExclude = strLength;
        }
        if (startInclude > endExclude) {
            return CryptoUtils.str(str);
        }
        char[] chars = new char[strLength];
        for (int i = 0; i < strLength; ++i) {
            chars[i] = i >= startInclude && i < endExclude ? replacedChar : str.charAt(i);
        }
        return new String(chars);
    }

    public static Object copy(Object src, int srcPos, Object dest, int destPos, int length) {
        System.arraycopy(src, srcPos, dest, destPos, length);
        return dest;
    }

    public static Object copy(Object src, Object dest, int length) {
        System.arraycopy(src, 0, dest, 0, length);
        return dest;
    }

    public static byte[] utf8Bytes(CharSequence str) {
        return CryptoUtils.bytes(str, CHARSET_UTF_8);
    }

    public static void close(Closeable closeable) {
        if (null != closeable) {
            try {
                closeable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static boolean startWith(CharSequence str, CharSequence prefix, boolean ignoreCase) {
        return CryptoUtils.startWith(str, prefix, ignoreCase, false);
    }

    public static boolean startWith(CharSequence str, CharSequence prefix, boolean ignoreCase, boolean ignoreEquals) {
        if (null == str || null == prefix) {
            if (!ignoreEquals) {
                return false;
            }
            return null == str && null == prefix;
        }
        boolean isStartWith = ignoreCase ? str.toString().toLowerCase().startsWith(prefix.toString().toLowerCase()) : str.toString().startsWith(prefix.toString());
        if (isStartWith) {
            return !ignoreEquals || !CryptoUtils.equals(str, prefix, ignoreCase);
        }
        return false;
    }

    public static boolean startWithIgnoreCase(CharSequence str, CharSequence prefix) {
        return CryptoUtils.startWith(str, prefix, true);
    }

    public static boolean equals(CharSequence str1, CharSequence str2) {
        return CryptoUtils.equals(str1, str2, false);
    }

    public static boolean equalsIgnoreCase(CharSequence str1, CharSequence str2) {
        return CryptoUtils.equals(str1, str2, true);
    }

    public static boolean equals(CharSequence str1, CharSequence str2, boolean ignoreCase) {
        if (null == str1) {
            return str2 == null;
        }
        if (null == str2) {
            return false;
        }
        if (ignoreCase) {
            return str1.toString().equalsIgnoreCase(str2.toString());
        }
        return str1.toString().contentEquals(str2);
    }

    public static int length(Object array) throws IllegalArgumentException {
        if (null == array) {
            return 0;
        }
        return Array.getLength(array);
    }

    public static byte[] resize(byte[] data, int newSize) {
        if (newSize < 0) {
            return data;
        }
        byte[] newArray = new byte[newSize];
        if (newSize > 0 && data != null && data.length > 0) {
            System.arraycopy(data, 0, newArray, 0, Math.min(data.length, newSize));
        }
        return newArray;
    }

    public static boolean isNotEmpty(Object array) {
        return !CryptoUtils.isEmpty(array);
    }

    public static boolean isEmpty(Object array) {
        if (array != null) {
            if (CryptoUtils.isArray(array)) {
                return 0 == Array.getLength(array);
            }
            return false;
        }
        return true;
    }

    public static boolean isMatch(Pattern pattern, CharSequence content) {
        if (content == null || pattern == null) {
            return false;
        }
        return pattern.matcher(content).matches();
    }

    public static boolean isMatchRegex(Pattern pattern, CharSequence value) {
        return CryptoUtils.isMatch(pattern, value);
    }

    public static boolean isHex(CharSequence value) {
        return CryptoUtils.isMatchRegex(HEX, value);
    }

    public static int lastIndexOfIgnoreCase(CharSequence str, CharSequence searchStr) {
        return CryptoUtils.lastIndexOfIgnoreCase(str, searchStr, str.length());
    }

    public static int lastIndexOfIgnoreCase(CharSequence str, CharSequence searchStr, int fromIndex) {
        return CryptoUtils.lastIndexOf(str, searchStr, fromIndex, true);
    }

    public static int lastIndexOf(CharSequence str, CharSequence searchStr, int fromIndex, boolean ignoreCase) {
        if (str == null || searchStr == null) {
            return -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        fromIndex = Math.min(fromIndex, str.length());
        if (searchStr.length() == 0) {
            return fromIndex;
        }
        if (!ignoreCase) {
            return str.toString().lastIndexOf(searchStr.toString(), fromIndex);
        }
        for (int i = fromIndex; i >= 0; --i) {
            if (!CryptoUtils.isSubEquals(str, i, searchStr, 0, searchStr.length(), true)) continue;
            return i;
        }
        return -1;
    }

    public static String sub(CharSequence str, int fromIndexInclude, int toIndexExclude) {
        if (CryptoUtils.isEmpty(str)) {
            return CryptoUtils.str(str);
        }
        int len = str.length();
        if (fromIndexInclude < 0) {
            if ((fromIndexInclude = len + fromIndexInclude) < 0) {
                fromIndexInclude = 0;
            }
        } else if (fromIndexInclude > len) {
            fromIndexInclude = len;
        }
        if (toIndexExclude < 0) {
            if ((toIndexExclude = len + toIndexExclude) < 0) {
                toIndexExclude = len;
            }
        } else if (toIndexExclude > len) {
            toIndexExclude = len;
        }
        if (toIndexExclude < fromIndexInclude) {
            int tmp = fromIndexInclude;
            fromIndexInclude = toIndexExclude;
            toIndexExclude = tmp;
        }
        if (fromIndexInclude == toIndexExclude) {
            return EMPTY;
        }
        return str.toString().substring(fromIndexInclude, toIndexExclude);
    }

    public static String subSuf(CharSequence string, int fromIndex) {
        if (CryptoUtils.isEmpty(string)) {
            return null;
        }
        return CryptoUtils.sub(string, fromIndex, string.length());
    }
}

