/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.consumerFinance.v_2.builder;

import com.alibaba.fastjson.JSONObject;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.SignUtils;
import com.upay.sdk.builder.BuilderSupport;
import com.upay.sdk.consumerFinance.v_2.entity.PersonalInfo;
import com.upay.sdk.consumerFinance.v_2.entity.ProductDetail;
import com.upay.sdk.core.CipherWrapper;
import java.util.LinkedList;
import java.util.List;

public final class OrderBuilder
extends BuilderSupport {
    private String merchantId;
    private String requestId;
    private String amount;
    private String notifyUrl;
    private String remark;
    private PersonalInfo personalInfo;
    private List<ProductDetail> productDetails = new LinkedList<ProductDetail>();

    public OrderBuilder(String merchantId) {
        this.merchantId = merchantId;
    }

    public JSONObject encryptBuild() {
        JSONObject json = super.assembleBuild();
        System.out.println("sdk \u7b7e\u540d :" + super.orderGenerateHmac());
        json.put("hmac", (Object)this.orderGenerateHmac());
        return CipherWrapper.encryptWrap(this.merchantId, json);
    }

    @Override
    protected String orderGenerateHmac() {
        return SignUtils.signMd5(super.orderGenerateHmac(), ConfigurationUtils.getHmacKey(this.merchantId));
    }

    public OrderBuilder setMerchantId(String merchantId) {
        this.merchantId = merchantId;
        return this;
    }

    public OrderBuilder setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public OrderBuilder setAmount(String amount) {
        this.amount = amount;
        return this;
    }

    public OrderBuilder setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
        return this;
    }

    public OrderBuilder setRemark(String remark) {
        this.remark = remark;
        return this;
    }

    public OrderBuilder setPersonalInfo(PersonalInfo personalInfo) {
        this.personalInfo = personalInfo;
        return this;
    }

    public OrderBuilder addProductDetail(ProductDetail productDetail) {
        this.productDetails.add(productDetail);
        return this;
    }
}

