/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.cashier.order.executer;

import com.alibaba.fastjson.JSONObject;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.Constants;
import com.upay.sdk.HttpClientUtils;
import com.upay.sdk.cashier.order.builder.ReceiptPaymentGetCaptchaBuilder;
import com.upay.sdk.core.response.HttpReponse;
import com.upay.sdk.exception.ResponseException;
import com.upay.sdk.exception.UnknownException;
import com.upay.sdk.executer.Executer;
import com.upay.sdk.executer.ResultListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReceiptPaymentGetCaptchaExecuter
extends Executer {
    static final Logger LOGGER = LoggerFactory.getLogger(ReceiptPaymentGetCaptchaExecuter.class);

    public void getKaptcha(ReceiptPaymentGetCaptchaBuilder builder, ResultListener resultListener) {
        block6: {
            try {
                String receiptPaymentCaptchaUrl = ConfigurationUtils.getReceiptPaymentCaptchaUrl();
                LOGGER.info("ReceiptPaymentGetCaptchaExecuter receiptPaymentCaptchaUrl:{}", (Object)receiptPaymentCaptchaUrl);
                HttpReponse httpJsonResponse = HttpClientUtils.sdkPost(receiptPaymentCaptchaUrl, builder);
                Object resObject = httpJsonResponse.getDecryptResponse();
                if (!(resObject instanceof JSONObject)) {
                    throw new RuntimeException("server response error,response object not a json!");
                }
                JSONObject responseData = (JSONObject)resObject;
                LOGGER.info("ReceiptPaymentGetCaptchaExecuter responseStr:[" + responseData + "]");
                String status = responseData.getString(Constants.STATUS);
                if (Constants.ERROR.equals(status)) {
                    throw new ResponseException(responseData);
                }
                this.bothVerifyHmacOrder(responseData);
                if (Constants.SUCCESS.equals(status)) {
                    resultListener.success(responseData);
                    break block6;
                }
                if (Constants.FAILED.equals(status)) {
                    resultListener.failure(responseData);
                    break block6;
                }
                throw new ResponseException(responseData);
            }
            catch (Exception e) {
                LOGGER.error("ReceiptPaymentGetCaptchaExecuter getKaptcha error", (Throwable)e);
                throw new UnknownException(e);
            }
        }
    }
}

