/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.cashier.bindcard.builder;

import com.alibaba.fastjson.JSONObject;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.RSAUtils;
import com.upay.sdk.SignUtils;
import com.upay.sdk.builder.BuilderSupport;
import com.upay.sdk.core.CipherWrapper;
import com.upay.sdk.exception.UnknownException;
import org.apache.commons.lang3.StringUtils;

public class BindCardBuilder
extends BuilderSupport {
    private String merchantId;
    private String merchantUserId;
    private String mode;
    private String bankCardNumber;
    private String phoneNumber;
    private String name;
    private String idCardNum;
    private String bankCode;
    private String cardType;
    private String bankCardCvv;
    private String validTerm;
    private String bindCardCallbackUrl;
    private String bindCardNotifyUrl;
    private String partnerId;

    public BindCardBuilder(String merchantId) {
        this.merchantId = merchantId;
    }

    public BindCardBuilder setMerchantUserId(String merchantUserId) {
        this.merchantUserId = merchantUserId;
        return this;
    }

    public BindCardBuilder setMerchantId(String merchantId) {
        this.merchantId = merchantId;
        return this;
    }

    public BindCardBuilder setBankCardNumber(String bankCardNumber) {
        this.bankCardNumber = bankCardNumber;
        return this;
    }

    public BindCardBuilder setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
        return this;
    }

    public BindCardBuilder setName(String name) {
        this.name = name;
        return this;
    }

    public BindCardBuilder setIdCardNum(String idCardNum) {
        this.idCardNum = idCardNum;
        return this;
    }

    public BindCardBuilder setBankCardCvv(String bankCardCvv) {
        this.bankCardCvv = bankCardCvv;
        return this;
    }

    public BindCardBuilder setValidTerm(String validTerm) {
        this.validTerm = validTerm;
        return this;
    }

    public String getBindCardCallbackUrl() {
        return this.bindCardCallbackUrl;
    }

    public BindCardBuilder setBindCardCallbackUrl(String bindCardCallbackUrl) {
        this.bindCardCallbackUrl = bindCardCallbackUrl;
        return this;
    }

    public String getBindCardNotifyUrl() {
        return this.bindCardNotifyUrl;
    }

    public BindCardBuilder setBindCardNotifyUrl(String bindCardNotifyUrl) {
        this.bindCardNotifyUrl = bindCardNotifyUrl;
        return this;
    }

    public String getPartnerId() {
        return this.partnerId;
    }

    public BindCardBuilder setPartnerId(String partnerId) {
        this.partnerId = partnerId;
        return this;
    }

    public String getMode() {
        return this.mode;
    }

    public BindCardBuilder setMode(String mode) {
        this.mode = mode;
        return this;
    }

    public String getBankCode() {
        return this.bankCode;
    }

    public BindCardBuilder setBankCode(String bankCode) {
        this.bankCode = bankCode;
        return this;
    }

    public String getCardType() {
        return this.cardType;
    }

    public BindCardBuilder setCardType(String cardType) {
        this.cardType = cardType;
        return this;
    }

    public JSONObject build() {
        JSONObject json = super.build(this.merchantId);
        json.put("merchantUserId", (Object)this.merchantUserId);
        if (StringUtils.isNotBlank((CharSequence)this.bankCardNumber)) {
            json.put("bankCardNumber", (Object)this.bankCardNumber);
        }
        if (StringUtils.isNotBlank((CharSequence)this.phoneNumber)) {
            json.put("phoneNumber", (Object)this.phoneNumber);
        }
        if (StringUtils.isNotBlank((CharSequence)this.name)) {
            json.put("name", (Object)this.name);
        }
        if (StringUtils.isNotBlank((CharSequence)this.idCardNum)) {
            json.put("idCardNum", (Object)this.idCardNum);
        }
        if (StringUtils.isNotBlank((CharSequence)this.bankCardCvv)) {
            json.put("bankCardCvv", (Object)this.bankCardCvv);
        }
        if (StringUtils.isNotBlank((CharSequence)this.validTerm)) {
            json.put("validTerm", (Object)this.validTerm);
        }
        json.put("hmac", (Object)this.generateHmac());
        return json;
    }

    private String generateHmac() {
        StringBuilder hmacSource = new StringBuilder();
        hmacSource.append(StringUtils.defaultString((String)this.merchantId)).append(StringUtils.defaultString((String)this.merchantUserId)).append(StringUtils.defaultString((String)this.bankCardNumber)).append(StringUtils.defaultString((String)this.phoneNumber)).append(StringUtils.defaultString((String)this.name)).append(StringUtils.defaultString((String)this.idCardNum)).append(StringUtils.defaultString((String)this.bankCardCvv)).append(StringUtils.defaultString((String)this.validTerm));
        return SignUtils.signMd5(hmacSource.toString(), ConfigurationUtils.getHmacKey(this.merchantId));
    }

    public JSONObject encryptBuild() {
        JSONObject json = super.assembleBuild();
        json.put("hmac", (Object)this.orderGenerateHmac());
        return CipherWrapper.encryptWrap(this.merchantId, json);
    }

    @Override
    protected String orderGenerateHmac() {
        String orderGenerateHmac = super.orderGenerateHmac();
        String hmacKey = ConfigurationUtils.getHmacKey(this.merchantId);
        return SignUtils.signMd5(orderGenerateHmac, hmacKey);
    }

    public JSONObject bothEncryptBuild() {
        JSONObject json = super.assembleBuild();
        try {
            json.put("hmac", (Object)this.bothOrderGenerateHmac());
        }
        catch (Exception e) {
            throw new UnknownException(e);
        }
        if (StringUtils.isNotBlank((CharSequence)this.partnerId)) {
            return CipherWrapper.bothEncryptWrap(this.merchantId, this.partnerId, json);
        }
        return CipherWrapper.bothEncryptWrap(this.merchantId, json);
    }

    protected byte[] bothOrderGenerateHmac() throws Exception {
        return RSAUtils.encryptSHA(super.orderGenerateHmac().getBytes("UTF-8"));
    }
}

