/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk;

import com.upay.sdk.crypto.utils.CryptoUtils;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignUtils {
    static final Logger LOGGER = LoggerFactory.getLogger(SignUtils.class);
    private static ThreadLocal threadLocal = new ThreadLocal(){

        protected synchronized Object initialValue() {
            MessageDigest messagedigest = null;
            try {
                messagedigest = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException var3) {
                LOGGER.error("\u521d\u59cb\u5316\u5931\u8d25\uff0cMessageDigest\u4e0d\u652f\u6301MD5Util", (Throwable)var3);
            }
            return messagedigest;
        }
    };

    public static MessageDigest getMessageDigest() {
        return (MessageDigest)threadLocal.get();
    }

    public static String signMd5(String source, String key) {
        byte[] value;
        byte[] keyb;
        LOGGER.info("SignUtils.signMd5 - key:[" + key + "]");
        byte[] k_ipad = new byte[64];
        byte[] k_opad = new byte[64];
        try {
            keyb = key.getBytes("UTF-8");
            value = source.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            keyb = key.getBytes();
            value = source.getBytes();
        }
        Arrays.fill(k_ipad, keyb.length, 64, (byte)54);
        Arrays.fill(k_opad, keyb.length, 64, (byte)92);
        for (int i = 0; i < keyb.length; ++i) {
            k_ipad[i] = (byte)(keyb[i] ^ 0x36);
            k_opad[i] = (byte)(keyb[i] ^ 0x5C);
        }
        MessageDigest md = SignUtils.getMessageDigest();
        md.update(k_ipad);
        md.update(value);
        byte[] dg = md.digest();
        md.reset();
        md.update(k_opad);
        md.update(dg, 0, 16);
        dg = md.digest();
        return CryptoUtils.encodeHexStr(dg);
    }
}

