/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk;

import com.alibaba.fastjson.JSONObject;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.builder.BuilderSupportWrap;
import com.upay.sdk.core.CipherWrapper;
import com.upay.sdk.core.response.HttpJsonResponse;
import com.upay.sdk.core.response.HttpReponse;
import com.upay.sdk.crypto.SdkEncryptDecryptSupport;
import com.upay.sdk.exception.HmacVerifyException;
import com.upay.sdk.exception.NotSupportException;
import com.upay.sdk.exception.RequestParamException;
import com.upay.sdk.exception.ResponseDecryptException;
import com.upay.sdk.exception.UnknownException;
import com.upay.sdk.tls.support.bc.TlsSocketConnectionFactory;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HttpClientUtils {
    static final Logger LOGGER = LoggerFactory.getLogger(HttpClientUtils.class);
    protected static final String CONTENT_TYPE = ConfigurationUtils.getHttpContentType();
    protected static final String CHARSET = "UTF-8";
    protected static final String CONTENT_ENCODING_ZIP = "gzip";
    protected static final String HEADER_CONTENT_ENCODING = "Content-Encoding";
    private static final String CN_LANGUAGE = "zh-CN";
    private static final HostnameVerifier SSL_HOSTNAME_VERIFIER = (urlHostName, session) -> true;
    private static final SSLSocketFactory SSL_SOCKET_FACTORY = new TlsSocketConnectionFactory();
    private static final String ENCRYPT_KEY = "encryptKey";
    private static final String MERCHANT_ID = "merchantId";
    private static final String REQUEST_ID = "requestId";
    private static final String PARTNER_ID = "partnerId";
    private static final String DATA = "data";

    private static HttpURLConnection createConnection(String urlStr) throws IOException {
        Integer connectTimeout;
        URL url = new URL(urlStr);
        HttpURLConnection con = (HttpURLConnection)url.openConnection();
        con.setDoOutput(true);
        con.setDoInput(true);
        con.setUseCaches(false);
        con.setInstanceFollowRedirects(false);
        con.setRequestMethod("POST");
        con.setRequestProperty("charset", CHARSET);
        con.setRequestProperty("User-Agent", "SDK/2.0");
        con.setRequestProperty("Accept-Language", CN_LANGUAGE);
        con.setRequestProperty("Accept-Encoding", CONTENT_ENCODING_ZIP);
        con.setUseCaches(false);
        if (con instanceof HttpsURLConnection) {
            HttpsURLConnection httpsCon = (HttpsURLConnection)con;
            httpsCon.setHostnameVerifier(SSL_HOSTNAME_VERIFIER);
            httpsCon.setSSLSocketFactory(SSL_SOCKET_FACTORY);
        }
        if ((connectTimeout = ConfigurationUtils.getConnectTimeout()) != null) {
            con.setConnectTimeout(connectTimeout);
            LOGGER.info("set connectTimeout:[" + connectTimeout + "]");
        } else {
            LOGGER.info("not set connectTimeout:[" + connectTimeout + "]");
        }
        Integer readTimeout = ConfigurationUtils.getReadTimeout();
        if (readTimeout != null) {
            con.setReadTimeout(readTimeout);
            LOGGER.info("set readTimeout:[" + readTimeout + "]");
        } else {
            LOGGER.info("not set readTimeout:[" + connectTimeout + "]");
        }
        return con;
    }

    @Deprecated
    public static String post3(String urlStr, JSONObject data) {
        return HttpClientUtils.postRequest(urlStr, data).getOriginalString();
    }

    public static <T> HttpReponse<T> sdkPost(String urlStr, BuilderSupportWrap builderSupportWrap) throws RequestParamException, ResponseDecryptException, HmacVerifyException {
        JSONObject jsonObject;
        try {
            jsonObject = builderSupportWrap.buildRequestParam();
        }
        catch (Exception e) {
            throw new RequestParamException(e);
        }
        HttpReponse<T> reponse = HttpClientUtils.postRequest(urlStr, jsonObject);
        reponse.decryptResponse();
        reponse.verifyHmac();
        return reponse;
    }

    private static <T> HttpReponse<T> postRequest(String urlStr, JSONObject data) {
        HttpURLConnection con = null;
        int httpResult = -1;
        try {
            BufferedReader br;
            LOGGER.debug("data:[" + data.toJSONString() + "]");
            con = HttpClientUtils.createConnection(urlStr);
            String encryptKey = HttpClientUtils.removeProperty(data, ENCRYPT_KEY);
            String merchantId = HttpClientUtils.removeProperty(data, MERCHANT_ID);
            String requestId = HttpClientUtils.removeProperty(data, REQUEST_ID);
            String partnerId = HttpClientUtils.removeProperty(data, PARTNER_ID);
            String body = HttpClientUtils.removeProperty(data, DATA);
            SdkEncryptDecryptSupport sdkEncryptDecryptSupport = CipherWrapper.getSdkEncryptDecryptSupport(merchantId, partnerId);
            con.setRequestProperty("Content-Type", sdkEncryptDecryptSupport.getContentType());
            con.setRequestProperty(ENCRYPT_KEY, encryptKey);
            con.setRequestProperty(MERCHANT_ID, merchantId);
            if (StringUtils.isNotBlank((CharSequence)requestId)) {
                con.setRequestProperty(REQUEST_ID, requestId);
            }
            if (StringUtils.isNotBlank((CharSequence)partnerId)) {
                con.setRequestProperty(PARTNER_ID, partnerId);
            }
            if (StringUtils.isNotBlank((CharSequence)body)) {
                DataOutputStream wr = new DataOutputStream(con.getOutputStream());
                wr.write(body.getBytes(CHARSET));
                wr.flush();
                wr.close();
            }
            httpResult = con.getResponseCode();
            StringBuilder sb = new StringBuilder();
            if (httpResult == 200) {
                String line;
                br = HttpClientUtils.getBufferedReader(con);
                while ((line = br.readLine()) != null) {
                    sb.append(line).append("\n");
                }
            } else {
                if (httpResult == 406) {
                    throw new UnknownException("Data error, Access denied. Http status is 406 !");
                }
                throw new UnknownException("httpStatusCode:" + httpResult + " msg:" + con.getResponseMessage());
            }
            br.close();
            HashMap<String, Object> responseProperties = new HashMap<String, Object>();
            String ek = con.getHeaderField(ENCRYPT_KEY);
            String mid = con.getHeaderField(MERCHANT_ID);
            String pid = con.getHeaderField(PARTNER_ID);
            responseProperties.put(ENCRYPT_KEY, ek);
            responseProperties.put(MERCHANT_ID, mid);
            if (StringUtils.isNotBlank((CharSequence)pid)) {
                responseProperties.put(PARTNER_ID, pid);
            }
            HttpJsonResponse httpJsonResponse = new HttpJsonResponse(httpResult, sb.toString(), responseProperties);
            return httpJsonResponse;
        }
        catch (Exception e) {
            LOGGER.info("http response urlStr[{}] status[{}]", (Object)urlStr, (Object)httpResult);
            throw new UnknownException(e);
        }
        finally {
            if (con != null) {
                con.disconnect();
            }
        }
    }

    @Deprecated
    public static String post2(String urlStr, JSONObject data) {
        throw new NotSupportException();
    }

    public static String post(String urlStr, String data) {
        StringBuilder sb;
        block8: {
            HttpURLConnection con = null;
            sb = new StringBuilder();
            int httpResult = 0;
            try {
                con = HttpClientUtils.createConnection(urlStr);
                con.setRequestProperty("Content-Type", CONTENT_TYPE);
                DataOutputStream wr = new DataOutputStream(con.getOutputStream());
                wr.write(data.getBytes(CHARSET));
                wr.flush();
                wr.close();
                httpResult = con.getResponseCode();
                if (httpResult == 200) {
                    BufferedReader br = HttpClientUtils.getBufferedReader(con);
                    String line = null;
                    while ((line = br.readLine()) != null) {
                        sb.append(line + "\n");
                    }
                    br.close();
                    break block8;
                }
                throw new UnknownException("httpStatusCode:" + httpResult + " msg:" + con.getResponseMessage());
            }
            catch (Exception e) {
                LOGGER.info("http response urlStr[{}] status[{}]", (Object)urlStr, (Object)httpResult);
                throw new UnknownException(e);
            }
            finally {
                if (con != null) {
                    con.disconnect();
                }
            }
        }
        return sb.toString();
    }

    public static String post(String urlStr, String data, String language) {
        StringBuilder sb;
        block8: {
            LOGGER.info("data:[" + data + "]");
            HttpURLConnection con = null;
            sb = new StringBuilder();
            int httpResult = 0;
            try {
                con = HttpClientUtils.createConnection(urlStr);
                con.setRequestProperty("Content-Type", CONTENT_TYPE);
                LOGGER.info("language:[" + language + "]");
                String strLanguage = language.replace("_", "-");
                con.setRequestProperty("Accept-Language", strLanguage);
                DataOutputStream wr = new DataOutputStream(con.getOutputStream());
                wr.write(data.getBytes(CHARSET));
                wr.flush();
                wr.close();
                httpResult = con.getResponseCode();
                if (httpResult == 200) {
                    BufferedReader br = HttpClientUtils.getBufferedReader(con);
                    String line = null;
                    while ((line = br.readLine()) != null) {
                        sb.append(line + "\n");
                    }
                    br.close();
                    break block8;
                }
                throw new UnknownException("httpStatusCode:" + httpResult + " msg:" + con.getResponseMessage());
            }
            catch (Exception e) {
                LOGGER.info("http response urlStr[{}] status[{}]", (Object)urlStr, (Object)httpResult);
                throw new UnknownException(e);
            }
            finally {
                if (con != null) {
                    con.disconnect();
                }
            }
        }
        return sb.toString();
    }

    public static String notify(String urlStr, String data) {
        StringBuilder sb;
        block8: {
            HttpURLConnection con = null;
            sb = new StringBuilder();
            try {
                con = HttpClientUtils.createConnection(urlStr);
                DataOutputStream wr = new DataOutputStream(con.getOutputStream());
                wr.write(data.getBytes(CHARSET));
                wr.flush();
                wr.close();
                int HttpResult = con.getResponseCode();
                if (HttpResult == 200) {
                    BufferedReader br = HttpClientUtils.getBufferedReader(con);
                    String line = null;
                    while ((line = br.readLine()) != null) {
                        sb.append(line + "\n");
                    }
                    br.close();
                    break block8;
                }
                throw new UnknownException("httpStatusCode:" + HttpResult + " msg:" + con.getResponseMessage());
            }
            catch (Exception e) {
                throw new UnknownException(e);
            }
            finally {
                if (con != null) {
                    con.disconnect();
                }
            }
        }
        return sb.toString();
    }

    private static BufferedReader getBufferedReader(HttpURLConnection con) throws IOException {
        String headerEncoding = con.getHeaderField(HEADER_CONTENT_ENCODING);
        BufferedReader br = CONTENT_ENCODING_ZIP.equals(headerEncoding) ? new BufferedReader(new InputStreamReader((InputStream)new GZIPInputStream(con.getInputStream()), CHARSET)) : new BufferedReader(new InputStreamReader(con.getInputStream(), CHARSET));
        return br;
    }

    private static String removeProperty(JSONObject jsonObject, String property) {
        Object val = jsonObject.remove((Object)property);
        return val == null ? null : String.valueOf(val);
    }

    static {
        System.setProperty("jdk.tls.allowUnsafeServerCertChange", "true");
        System.setProperty("sun.security.ssl.allowUnsafeRenegotiation", "true");
    }
}

