/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.crypto.sm.utils;

import com.upay.sdk.crypto.sm.utils.SM2FileKeyUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;

public class SMUtils {
    static final ASN1ObjectIdentifier sm_scheme = new ASN1ObjectIdentifier("1.2.156.10197.1");
    static final ASN1ObjectIdentifier sm2sign_with_sm3 = sm_scheme.branch("501");

    private static boolean checkPath(String cerPath) {
        if (StringUtils.isNotBlank((CharSequence)cerPath)) {
            File cerFile = new File(cerPath);
            return cerFile.exists();
        }
        return false;
    }

    public static X509Certificate parseSMCertificate(InputStream inputStream) throws CertificateException, NoSuchProviderException {
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509", "BC");
        return (X509Certificate)certificateFactory.generateCertificate(inputStream);
    }

    public static boolean isSM2PublishKey(InputStream inputStream) throws CertificateException, NoSuchProviderException {
        X509Certificate x509Certificate = SMUtils.parseSMCertificate(inputStream);
        String signAlgOld = x509Certificate.getSigAlgOID();
        return sm2sign_with_sm3.getId().equals(signAlgOld);
    }

    public static boolean isSM2PublishKey(String cerPath) throws CertificateException, IOException, NoSuchProviderException {
        if (!SMUtils.checkPath(cerPath)) {
            return false;
        }
        try (InputStream inputStream = null;){
            inputStream = Files.newInputStream(Paths.get(cerPath, new String[0]), new OpenOption[0]);
            boolean bl = SMUtils.isSM2PublishKey(inputStream);
            return bl;
        }
    }

    public static byte[] readSM2PublishKey(InputStream inputStream) throws CertificateException, NoSuchProviderException {
        X509Certificate x509Certificate = SMUtils.parseSMCertificate(inputStream);
        String signAlgOld = x509Certificate.getSigAlgOID();
        if (sm2sign_with_sm3.getId().equals(signAlgOld)) {
            return x509Certificate.getPublicKey().getEncoded();
        }
        return null;
    }

    public static byte[] readSM2PublishKey(String cerPath) throws CertificateException, IOException, NoSuchProviderException {
        if (!SMUtils.checkPath(cerPath)) {
            return null;
        }
        try (InputStream inputStream = null;){
            inputStream = Files.newInputStream(Paths.get(cerPath, new String[0]), new OpenOption[0]);
            byte[] byArray = SMUtils.readSM2PublishKey(inputStream);
            return byArray;
        }
    }

    public static boolean isSM2File(byte[] fileData, String password) {
        if (fileData == null || fileData.length == 0) {
            return false;
        }
        try {
            SM2FileKeyUtils.getPrivateKey(fileData, password);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }
}

