/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.crypto.sm.spi;

import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.core.Environment;
import com.upay.sdk.crypto.EncryptionAlgorithm;
import com.upay.sdk.crypto.SdkEncryptDecryptSupport;
import com.upay.sdk.crypto.sm.crypto.SmUtil;
import com.upay.sdk.crypto.sm.crypto.asymmetric.KeyType;
import com.upay.sdk.crypto.sm.crypto.asymmetric.SM2;
import com.upay.sdk.crypto.sm.crypto.symmetric.SM4;
import java.security.Provider;
import java.security.Security;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class SmAlgorithmSupportImpl
implements SdkEncryptDecryptSupport {
    public String getContentType() {
        return ConfigurationUtils.getHttpContentTypeV4();
    }

    public boolean isSupport(EncryptionAlgorithm encryptionAlgorithm) {
        return encryptionAlgorithm == EncryptionAlgorithm.SM;
    }

    public byte[] digest(byte[] data) {
        return SmUtil.sm3(new String(data, Environment.DEFAULT_CHARSET)).getBytes(Environment.DEFAULT_CHARSET);
    }

    public String sign(byte[] data, String privateKeyBase64Str) {
        SM2 sm2 = SmUtil.sm2(privateKeyBase64Str, null);
        return sm2.signHex(new String(data, Environment.DEFAULT_CHARSET));
    }

    public boolean verify(byte[] data, String publicKey, String sign) {
        SM2 sm2 = SmUtil.sm2(null, publicKey);
        return sm2.verifyHex(new String(data, Environment.DEFAULT_CHARSET), sign);
    }

    public String symmetricEncrypt(String data, String key) {
        SM4 sm4 = SmUtil.sm4(key.getBytes(Environment.DEFAULT_CHARSET));
        return sm4.encryptHex(data, Environment.DEFAULT_CHARSET);
    }

    public String symmetricDecrypt(String data, String key) {
        SM4 sm4 = SmUtil.sm4(key.getBytes(Environment.DEFAULT_CHARSET));
        return sm4.decryptStr(data, Environment.DEFAULT_CHARSET);
    }

    public String asymmetricEncrypt(String data, String publicKeyBase64Str) {
        SM2 sm2 = SmUtil.sm2(null, publicKeyBase64Str);
        return sm2.encryptBcd(data, KeyType.PublicKey, Environment.DEFAULT_CHARSET);
    }

    public String asymmetricDecrypt(String data, String privateKeyBase64Str) {
        SM2 sm2 = SmUtil.sm2(privateKeyBase64Str, null);
        return new String(sm2.decryptFromBcd(data, KeyType.PrivateKey, Environment.DEFAULT_CHARSET), Environment.DEFAULT_CHARSET);
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

