/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.crypto.sm.crypto.digest;

import com.upay.sdk.crypto.sm.crypto.digest.HmacAlgorithm;
import com.upay.sdk.crypto.sm.crypto.digest.mac.MacEngine;
import com.upay.sdk.crypto.sm.crypto.digest.mac.MacEngineFactory;
import com.upay.sdk.crypto.utils.CryptoUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.security.Key;
import java.security.MessageDigest;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class HMac
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private final MacEngine engine;

    public HMac(HmacAlgorithm algorithm) {
        this(algorithm, (Key)null);
    }

    public HMac(HmacAlgorithm algorithm, byte[] key) {
        this(algorithm.getValue(), key);
    }

    public HMac(HmacAlgorithm algorithm, Key key) {
        this(algorithm.getValue(), key);
    }

    public HMac(String algorithm, byte[] key) {
        this(algorithm, (Key)new SecretKeySpec(key, algorithm));
    }

    public HMac(String algorithm, Key key) {
        this(algorithm, key, null);
    }

    public HMac(String algorithm, Key key, AlgorithmParameterSpec spec) {
        this(MacEngineFactory.createEngine(algorithm, key, spec));
    }

    public HMac(MacEngine engine) {
        this.engine = engine;
    }

    public MacEngine getEngine() {
        return this.engine;
    }

    public byte[] digest(String data, Charset charset) {
        return this.digest(CryptoUtils.bytes((CharSequence)data, (Charset)charset));
    }

    public byte[] digest(String data) {
        return this.digest(data, CryptoUtils.CHARSET_UTF_8);
    }

    public byte[] digest(byte[] data) {
        return this.digest(new ByteArrayInputStream(data), -1);
    }

    public byte[] digest(InputStream data) {
        return this.digest(data, 8192);
    }

    public byte[] digest(InputStream data, int bufferLength) {
        return this.engine.digest(data, bufferLength);
    }

    public boolean verify(byte[] digest, byte[] digestToCompare) {
        return MessageDigest.isEqual(digest, digestToCompare);
    }

    public String getAlgorithm() {
        return this.engine.getAlgorithm();
    }
}

