/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.webox.builder;

import com.alibaba.fastjson.JSONObject;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.RSAUtils;
import com.upay.sdk.SignUtils;
import com.upay.sdk.builder.BuilderSupport;
import com.upay.sdk.core.CipherWrapper;
import com.upay.sdk.exception.UnknownException;

public class WalletBaseInfoQueryBuilder
extends BuilderSupport {
    private String walletId;
    private String deviceNo;
    private String requestId;
    private String merchantId;

    public WalletBaseInfoQueryBuilder(String merchantId) {
        this.merchantId = merchantId;
    }

    public WalletBaseInfoQueryBuilder setMerchantId(String merchantId) {
        this.merchantId = merchantId;
        return this;
    }

    public WalletBaseInfoQueryBuilder setWalletId(String walletId) {
        this.walletId = walletId;
        return this;
    }

    public WalletBaseInfoQueryBuilder setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public WalletBaseInfoQueryBuilder setDeviceNo(String deviceNo) {
        this.deviceNo = deviceNo;
        return this;
    }

    public JSONObject encryptBuild() {
        JSONObject json = super.assembleBuild();
        json.put("hmac", (Object)this.orderGenerateHmac());
        return CipherWrapper.encryptWrap(this.merchantId, json);
    }

    @Override
    protected String orderGenerateHmac() {
        String orderGenerateHmac = super.orderGenerateHmac();
        return SignUtils.signMd5(orderGenerateHmac, ConfigurationUtils.getHmacKey(this.merchantId));
    }

    public JSONObject bothEncryptBuild() {
        JSONObject json = super.assembleBuild();
        try {
            json.put("hmac", (Object)this.bothOrderGenerateHmac());
        }
        catch (Exception e) {
            throw new UnknownException(e);
        }
        return CipherWrapper.bothEncryptWrap(this.merchantId, json);
    }

    protected byte[] bothOrderGenerateHmac() throws Exception {
        return RSAUtils.encryptSHA(super.orderGenerateHmac().getBytes("UTF-8"));
    }
}

