/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.prepaycard.executer;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.Constants;
import com.upay.sdk.HttpClientUtils;
import com.upay.sdk.core.CipherWrapper;
import com.upay.sdk.exception.ResponseException;
import com.upay.sdk.exception.UnknownException;
import com.upay.sdk.executer.Executer;
import com.upay.sdk.executer.HmacArray;
import com.upay.sdk.executer.ResultListener;
import com.upay.sdk.prepaycard.builder.BalanceQueryBuilder;
import com.upay.sdk.prepaycard.builder.DestroyCardQueryBuilder;
import com.upay.sdk.prepaycard.builder.OrderBuilder;
import com.upay.sdk.prepaycard.builder.QueryBuilder;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PcardOnlinePayOrderExecuter
extends Executer {
    static final Logger LOGGER = LoggerFactory.getLogger(PcardOnlinePayOrderExecuter.class);
    static final String[] ORDER_RESPONSE_HMAC_FIELDS = new String[]{Constants.MERCHANT_ID, Constants.REQUEST_ID, Constants.STATUS, "redirectUrl", "scanCode", "appParams"};
    static final Object[] QUERY_RESPONSE_HMAC_FIELDS = new Object[]{Constants.MERCHANT_ID, Constants.REQUEST_ID, Constants.SERIAL_NUMBER, "currency", "amount", Constants.STATUS, "completeDateTime", "remark", HmacArray.create("destoryCards", new String[]{"cardNo", "resultMessage", "balanceAmount", "cardType", "tradeAmount"})};
    static final Object[] BALANCE_CARD_QUERY_RESPONSE_HMAC_FIELDS = new Object[]{Constants.MERCHANT_ID, Constants.REQUEST_ID, "isAvailable", "amount", "status", "errorMessage"};
    static final Object[] DESTROY_CARD_QUERY_RESPONSE_HMAC_FIELD = new Object[]{Constants.MERCHANT_ID, "cardType", "cardNo", "queryResult", HmacArray.create("items", new String[]{"orderId", "status", "errorMessage", "createDateTime", "completeDateTime"})};
    static final String[] REFUND_RESPONSE_HMAC_FIELDS = new String[]{Constants.MERCHANT_ID, Constants.REQUEST_ID, Constants.SERIAL_NUMBER, "orderId", Constants.STATUS, "errorMessage", "amount", "currency", "completeDateTime"};

    public void order(OrderBuilder builder, ResultListener resultListener) {
        block5: {
            try {
                JSONObject requestData = builder.encryptBuild();
                LOGGER.debug("requestData:[" + requestData.toJSONString() + "]");
                String responseStr = HttpClientUtils.post2(ConfigurationUtils.getPcardOnlinePayOrderUrl(), requestData);
                LOGGER.debug("responseStr:[" + responseStr + "]");
                JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
                String status = responseData.getString(Constants.STATUS);
                if (Constants.ERROR.equals(status)) {
                    throw new ResponseException(responseData);
                }
                responseData = CipherWrapper.decryptWrap(responseData);
                LOGGER.debug("responseStr:[" + responseData + "]");
                this.verifyHmacOrder(responseData);
                if (Constants.REDIRECT.equals(responseData.getString(Constants.STATUS))) {
                    resultListener.redirect(responseData, responseData.getString("redirectUrl"));
                    break block5;
                }
                if (Constants.SUCCESS.equals(responseData.getString(Constants.STATUS))) {
                    resultListener.success(responseData);
                    break block5;
                }
                throw new ResponseException(responseData);
            }
            catch (IOException e) {
                LOGGER.error("request order exception", (Throwable)e);
                throw new UnknownException(e);
            }
        }
    }

    public void callback(JSONObject responseData, ResultListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        JSONObject data = CipherWrapper.decryptWrap(responseData);
        this.verifyHmacOrder(data);
        String status = data.getString(Constants.STATUS);
        if (status != null && !status.equals("")) {
            if (Constants.SUCCESS.equals(status)) {
                listener.success(data);
            } else if (Constants.FAILED.equals(status) || Constants.CANCEL.equals(status)) {
                listener.failure(data);
            } else if (Constants.INIT.equals(status)) {
                listener.pending(data);
            } else if (Constants.PROCESSING.equals(status)) {
                listener.processing(data);
            } else {
                throw new ResponseException(data);
            }
        }
    }

    public void query(QueryBuilder builder, ResultListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        try {
            JSONObject requestData = builder.encryptBuild();
            LOGGER.debug("requestData:[" + requestData + "]");
            String responseStr = HttpClientUtils.post2(ConfigurationUtils.getPcardOnlinePayQueryUrl(), requestData);
            JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
            String status = responseData.getString(Constants.STATUS);
            if (Constants.ERROR.equals(status)) {
                LOGGER.debug("decrypt responseData : {}", (Object)responseData);
                throw new ResponseException(responseData);
            }
            LOGGER.debug("responseStr:[" + responseStr + "]");
            this.callback(responseData, listener);
        }
        catch (Exception e) {
            LOGGER.error("request order exception", (Throwable)e);
            throw new UnknownException(e);
        }
    }

    public void balanceCardQuery(BalanceQueryBuilder builder, ResultListener listener) {
        block5: {
            if (listener == null) {
                throw new NullPointerException();
            }
            try {
                JSONObject requestData = builder.encryptBuild();
                LOGGER.debug("requestData:[" + requestData + "]");
                String responseStr = HttpClientUtils.post2(ConfigurationUtils.getPcardBalanceCardQueryUrl(), requestData);
                JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
                responseData = CipherWrapper.decryptWrap(responseData);
                String status = responseData.getString(Constants.STATUS);
                LOGGER.debug("responseData:[" + responseData + "]");
                this.verifyHmacOrder(responseData);
                if (Constants.SUCCESS.equals(status)) {
                    listener.success(responseData);
                    break block5;
                }
                if (Constants.FAILED.equals(status)) {
                    listener.failure(responseData);
                    break block5;
                }
                throw new ResponseException(responseData);
            }
            catch (Exception e) {
                LOGGER.error("request order exception", (Throwable)e);
                throw new UnknownException(e);
            }
        }
    }

    public void destroyCardQuery(DestroyCardQueryBuilder builder, ResultListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        try {
            JSONObject requestData = builder.encryptBuild();
            LOGGER.debug("requestData:[" + requestData + "]");
            String responseStr = HttpClientUtils.post2(ConfigurationUtils.getPcardDestroyCardQueryUrl(), requestData);
            JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
            responseData = CipherWrapper.decryptWrap(responseData);
            String status = responseData.getString(Constants.STATUS);
            LOGGER.debug("responseData:[" + responseData + "]");
            this.verifyHmacOrder(responseData);
            String realCardNo = responseData.getString("cardNo");
            responseData.put("cardNo", (Object)realCardNo);
            if (Constants.SUCCESS.equals(status)) {
                listener.success(responseData);
            } else if (Constants.FAILED.equals(status)) {
                listener.failure(responseData);
            }
        }
        catch (Exception e) {
            LOGGER.error("request order exception", (Throwable)e);
            throw new UnknownException(e);
        }
    }
}

