/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.prepaycard.builder;

import com.alibaba.fastjson.JSONObject;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.SignUtils;
import com.upay.sdk.builder.BuilderSupport;
import com.upay.sdk.core.CipherWrapper;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class BalanceQueryBuilder
extends BuilderSupport {
    private String merchantId;
    private String requestId;
    private String cardNo;
    private String password;

    public BalanceQueryBuilder(String merchantId) {
        this.merchantId = merchantId;
    }

    public BalanceQueryBuilder setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public BalanceQueryBuilder setCardNo(String cardNo) {
        this.cardNo = cardNo;
        return this;
    }

    public BalanceQueryBuilder setPassword(String password) {
        this.password = password;
        return this;
    }

    public JSONObject build() {
        JSONObject json = super.build(this.merchantId);
        if (StringUtils.isNotBlank((CharSequence)this.requestId)) {
            json.put("requestId", (Object)this.requestId);
        }
        if (StringUtils.isNotBlank((CharSequence)this.cardNo)) {
            json.put("cardNo", (Object)this.cardNo);
        }
        if (StringUtils.isNotBlank((CharSequence)this.password)) {
            json.put("password", (Object)this.password);
        }
        json.put("hmac", (Object)this.generateHmac());
        return json;
    }

    private String generateHmac() {
        StringBuilder hmacSource = new StringBuilder();
        hmacSource.append(StringUtils.defaultString((String)this.merchantId)).append(StringUtils.defaultString((String)this.requestId)).append((String)ObjectUtils.defaultIfNull((Object)this.cardNo, (Object)"")).append(StringUtils.defaultString((String)this.password, (String)""));
        return SignUtils.signMd5(hmacSource.toString(), ConfigurationUtils.getHmacKey(this.merchantId));
    }

    public JSONObject encryptBuild() {
        JSONObject json = super.assembleBuild();
        json.put("hmac", (Object)this.orderGenerateHmac());
        return CipherWrapper.encryptWrap(this.merchantId, json);
    }

    @Override
    protected String orderGenerateHmac() {
        return SignUtils.signMd5(super.orderGenerateHmac(), ConfigurationUtils.getHmacKey(this.merchantId));
    }
}

