/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.jointaccount.v_2.executer;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.Constants;
import com.upay.sdk.HttpClientUtils;
import com.upay.sdk.core.CipherWrapper;
import com.upay.sdk.exception.ResponseException;
import com.upay.sdk.executer.Executer;
import com.upay.sdk.executer.ResultListener;
import com.upay.sdk.jointaccount.v_2.builder.JointaccountBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JointaccountExecuter
extends Executer {
    static final Logger LOGGER = LoggerFactory.getLogger(JointaccountExecuter.class);

    public void create(JointaccountBuilder jointaccountBuilder, ResultListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        String responseStr = HttpClientUtils.post2(ConfigurationUtils.getJointaccountCreateUrl(), jointaccountBuilder.encryptBuild());
        LOGGER.info("responseStr:[" + responseStr + "]");
        JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
        responseData = CipherWrapper.decryptWrap(responseData);
        this.verifyHmacOrder(responseData);
        String status = responseData.getString(Constants.STATUS);
        if (!Constants.SUCCESS.equals(status)) {
            throw new ResponseException(responseData);
        }
        listener.success(responseData);
    }
}

