/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.jointaccount.v_2.executer;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.Constants;
import com.upay.sdk.HttpClientUtils;
import com.upay.sdk.core.CipherWrapper;
import com.upay.sdk.exception.ResponseException;
import com.upay.sdk.exception.UnknownException;
import com.upay.sdk.executer.Executer;
import com.upay.sdk.executer.HmacArray;
import com.upay.sdk.executer.ResultListener;
import com.upay.sdk.jointaccount.v_2.builder.JointOnlinePayOrderBuilder;
import com.upay.sdk.onlinepay.builder.QueryBuilder;
import com.upay.sdk.onlinepay.builder.RefundBuilder;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JointOnlinePayOrderExecuter
extends Executer {
    static final Logger LOGGER = LoggerFactory.getLogger(JointOnlinePayOrderExecuter.class);
    static final String[] ORDER_RESPONSE_HMAC_FIELDS = new String[]{Constants.MERCHANT_ID, Constants.REQUEST_ID, Constants.STATUS, Constants.SCANCODE, Constants.APPPARAMS, "redirectUrl"};
    static final Object[] QUERY_RESPONSE_HMAC_FIELDS = new Object[]{Constants.MERCHANT_ID, Constants.REQUEST_ID, Constants.SERIAL_NUMBER, "totalRefundCount", "totalRefundAmount", "orderCurrency", "orderAmount", Constants.STATUS, "completeDateTime", "remark", "bindCardId", HmacArray.create("subOrders", new String[]{Constants.REQUEST_ID, "orderAmount", Constants.SERIAL_NUMBER}), "usersSign"};
    static final String[] REFUND_RESPONSE_HMAC_FIELDS = new String[]{Constants.MERCHANT_ID, Constants.REQUEST_ID, Constants.SERIAL_NUMBER, "orderId", Constants.STATUS, "errorMessage", "amount", "currency", "completeDateTime"};

    public void order(JointOnlinePayOrderBuilder builder, ResultListener resultListener) {
        block5: {
            try {
                JSONObject requestData = builder.encryptBuild();
                LOGGER.debug("JointOnlinePayOrderExecuter requestData:[" + requestData.toJSONString() + "]");
                String responseStr = HttpClientUtils.post2(ConfigurationUtils.getJointOnlinePayOrderUrl(), requestData);
                JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
                String status = responseData.getString(Constants.STATUS);
                if (Constants.ERROR.equals(status)) {
                    throw new ResponseException(responseData);
                }
                responseData = CipherWrapper.decryptWrap(responseData);
                LOGGER.debug("JointOnlinePayOrderExecuter responseStr:[" + responseData + "]");
                this.verifyHmacOrder(responseData);
                if (Constants.REDIRECT.equals(responseData.getString(Constants.STATUS))) {
                    resultListener.redirect(responseData, responseData.getString("redirectUrl"));
                    break block5;
                }
                if (Constants.SUCCESS.equals(responseData.getString(Constants.STATUS))) {
                    resultListener.success(responseData);
                    break block5;
                }
                throw new ResponseException(responseData);
            }
            catch (Exception e) {
                LOGGER.error("request order exception", (Throwable)e);
                throw new UnknownException(e);
            }
        }
    }

    public void refund(RefundBuilder builder, ResultListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        String responseStr = HttpClientUtils.post2(ConfigurationUtils.getOnlinePayRefundUrl(), builder.encryptBuild());
        LOGGER.debug("responseStr:[" + responseStr + "]");
        JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
        String status = responseData.getString(Constants.STATUS);
        if (Constants.ERROR.equals(status)) {
            throw new ResponseException(responseData);
        }
        responseData = CipherWrapper.decryptWrap(responseData);
        this.verifyHmacOrder(responseData);
        status = responseData.getString(Constants.STATUS);
        if (Constants.SUCCESS.equals(status)) {
            listener.success(responseData);
        } else if (Constants.FAILED.equals(status)) {
            listener.failure(responseData);
        } else if (Constants.INIT.equals(status)) {
            listener.pending(responseData);
        } else {
            throw new ResponseException(responseData);
        }
    }

    public void query(QueryBuilder builder, ResultListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        try {
            JSONObject requestData = builder.encryptBuild();
            LOGGER.debug("requestData:[" + requestData + "]");
            String responseStr = HttpClientUtils.post2(ConfigurationUtils.getOnlinePayQueryUrl(), requestData);
            JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
            String status = responseData.getString(Constants.STATUS);
            if (Constants.ERROR.equals(status)) {
                LOGGER.debug("decrypt responseData : {}", (Object)responseData);
                throw new ResponseException(responseData);
            }
            LOGGER.debug("responseStr:[" + responseStr + "]");
            this.cipherCallback(responseData, listener);
        }
        catch (Exception e) {
            LOGGER.error("request order exception", (Throwable)e);
            throw new UnknownException(e);
        }
    }

    public void refundQuery(RefundBuilder builder, ResultListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        try {
            String responseStr = HttpClientUtils.post2(ConfigurationUtils.getOnlinePayRefundQueryUrl(), builder.encryptBuild());
            LOGGER.debug("responseStr:[" + responseStr + "]");
            JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
            String status = responseData.getString(Constants.STATUS);
            if (Constants.ERROR.equals(status)) {
                LOGGER.debug("decrypt responseData : {}", (Object)responseData);
                throw new ResponseException(responseData);
            }
            LOGGER.debug("responseStr:[" + responseStr + "]");
            this.cipherRefundCallback(responseData, listener);
        }
        catch (Exception e) {
            LOGGER.error("request order exception", (Throwable)e);
            throw new UnknownException(e);
        }
    }

    public void cipherCallback(JSONObject responseData, ResultListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        JSONObject data = CipherWrapper.decryptWrap(responseData);
        this.verifyHmacOrder(data);
        String status = data.getString(Constants.STATUS);
        if (StringUtils.isNotBlank((CharSequence)status)) {
            if (Constants.SUCCESS.equals(status)) {
                listener.success(data);
            } else if (Constants.FAILED.equals(status) || Constants.CANCEL.equals(status)) {
                listener.failure(data);
            } else if (Constants.INIT.equals(status)) {
                listener.pending(data);
            } else {
                throw new ResponseException(data);
            }
        }
    }

    public void cipherRefundCallback(JSONObject responseData, ResultListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        responseData = CipherWrapper.decryptWrap(responseData);
        this.verifyHmacOrder(responseData);
        String status = responseData.getString(Constants.STATUS);
        if (Constants.SUCCESS.equals(status)) {
            listener.success(responseData);
        } else if (Constants.FAILED.equals(status) || Constants.CANCEL.equals(status)) {
            listener.failure(responseData);
        } else if (Constants.INIT.equals(status)) {
            listener.pending(responseData);
        } else {
            throw new ResponseException(responseData);
        }
    }
}

