/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.jointaccount.v_2.builder;

import com.alibaba.fastjson.JSONObject;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.SignUtils;
import com.upay.sdk.builder.BuilderSupport;
import com.upay.sdk.core.CipherWrapper;
import com.upay.sdk.entity.Payer;
import com.upay.sdk.entity.ProductDetail;
import java.util.LinkedList;
import java.util.List;

public final class JointOnlinePayOrderBuilder
extends BuilderSupport {
    private String merchantId;
    private String orderAmount;
    private String orderCurrency;
    private String requestId;
    private String notifyUrl;
    private String callbackUrl;
    private String openId;
    private Payer payer;
    private String clientIp;
    private String jointNumber;
    private List<ProductDetail> productDetails = new LinkedList<ProductDetail>();

    public JointOnlinePayOrderBuilder(String merchantId) {
        this.merchantId = merchantId;
    }

    public JointOnlinePayOrderBuilder setOrderAmount(String orderAmount) {
        this.orderAmount = orderAmount;
        return this;
    }

    public JointOnlinePayOrderBuilder setOrderCurrency(String orderCurrency) {
        this.orderCurrency = orderCurrency;
        return this;
    }

    public JointOnlinePayOrderBuilder setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public JointOnlinePayOrderBuilder setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
        return this;
    }

    public JointOnlinePayOrderBuilder setCallbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
        return this;
    }

    public JointOnlinePayOrderBuilder setOpenId(String openId) {
        this.openId = openId;
        return this;
    }

    public JointOnlinePayOrderBuilder setPayer(Payer payer) {
        this.payer = payer;
        return this;
    }

    public JointOnlinePayOrderBuilder addProductDetail(ProductDetail productDetail) {
        this.productDetails.add(productDetail);
        return this;
    }

    public JointOnlinePayOrderBuilder setClientIp(String clientIp) {
        this.clientIp = clientIp;
        return this;
    }

    public JointOnlinePayOrderBuilder setJointNumber(String jointNumber) {
        this.jointNumber = jointNumber;
        return this;
    }

    public JSONObject encryptBuild() {
        JSONObject json = super.assembleBuild();
        System.out.println("sdk \u7b7e\u540d :" + super.orderGenerateHmac());
        json.put("hmac", (Object)this.orderGenerateHmac());
        return CipherWrapper.encryptWrap(this.merchantId, json);
    }

    @Override
    protected String orderGenerateHmac() {
        return SignUtils.signMd5(super.orderGenerateHmac(), ConfigurationUtils.getHmacKey(this.merchantId));
    }
}

