/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.icc.v_3.builder;

import com.alibaba.fastjson.JSONObject;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.RSAUtils;
import com.upay.sdk.SignUtils;
import com.upay.sdk.builder.BuilderSupport;
import com.upay.sdk.core.CipherWrapper;
import com.upay.sdk.exception.UnknownException;
import org.apache.commons.lang.StringUtils;

public class RefundBuilder
extends BuilderSupport {
    private String merchantId;
    private String requestId;
    private String orderRequestId;
    private String amount;
    private String notifyUrl;
    private String remark;
    private String partnerId;

    public RefundBuilder(String merchantId) {
        this.merchantId = merchantId;
    }

    public RefundBuilder setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public RefundBuilder setOrderRequestId(String orderRequestId) {
        this.orderRequestId = orderRequestId;
        return this;
    }

    public RefundBuilder setAmount(String amount) {
        this.amount = amount;
        return this;
    }

    public RefundBuilder setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
        return this;
    }

    public RefundBuilder setRemark(String remark) {
        this.remark = remark;
        return this;
    }

    public RefundBuilder setPartnerId(String partnerId) {
        this.partnerId = partnerId;
        return this;
    }

    @Override
    protected String orderGenerateHmac() {
        return SignUtils.signMd5(super.orderGenerateHmac(), ConfigurationUtils.getHmacKey(StringUtils.isBlank((String)this.partnerId) ? this.merchantId : this.partnerId));
    }

    public JSONObject bothEncryptBuild() {
        JSONObject json = super.assembleBuild();
        try {
            json.put("hmac", (Object)this.bothOrderGenerateHmac());
        }
        catch (Exception e) {
            throw new UnknownException(e);
        }
        if (StringUtils.isNotBlank((String)this.partnerId)) {
            return CipherWrapper.bothEncryptWrap(this.merchantId, this.partnerId, json);
        }
        return CipherWrapper.bothEncryptWrap(this.merchantId, json);
    }

    protected byte[] bothOrderGenerateHmac() throws Exception {
        return RSAUtils.encryptSHA(super.orderGenerateHmac().getBytes("UTF-8"));
    }
}

