/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.foreignpayExchangesettlement.executer;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.Constants;
import com.upay.sdk.HttpClientUtils;
import com.upay.sdk.exception.ResponseException;
import com.upay.sdk.exception.UnknownException;
import com.upay.sdk.executer.Executer;
import com.upay.sdk.executer.ResultListener;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForeignpayExchangesettlementOrderExecuter
extends Executer {
    static final Logger LOGGER = LoggerFactory.getLogger(ForeignpayExchangesettlementOrderExecuter.class);
    static final String[] ORDER_BATCH_RESPONSE_HMAC_FILEDS = new String[]{Constants.MERCHANT_ID, Constants.REQUEST_ID, Constants.STATUS, Constants.ERROR_MSG, "errorCode", "redirectUrl"};
    static final String[] QUERY_BATCH_RESPONSE_HMAC_FILEDS = new String[]{Constants.MERCHANT_ID, Constants.REQUEST_ID, Constants.SERIAL_NUMBER, "amount", "currency", "remark", "completeDateTime", Constants.STATUS};

    public void orderBatch(JSONObject requestData, ResultListener resultListener) {
        block5: {
            LOGGER.info("ForeignpayExchangesettlementOrderExecuter orderBatch requestData:{}", (Object)requestData.toJSONString());
            String responseStr = HttpClientUtils.post(ConfigurationUtils.getForeignpayExchangesettlementOrderBatchUrl(), requestData.toJSONString());
            LOGGER.info("ForeignpayExchangesettlementOrderExecuter orderBatch responseStr:{}", (Object)responseStr);
            JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
            if (StringUtils.isBlank((CharSequence)responseData.toJSONString())) {
                throw new NullPointerException("responseData is null");
            }
            this.verifyHmac(ORDER_BATCH_RESPONSE_HMAC_FILEDS, responseData);
            try {
                if (Constants.SUCCESS.equals(responseData.getString(Constants.STATUS))) {
                    resultListener.success(responseData);
                    break block5;
                }
                if (Constants.REDIRECT.equals(responseData.getString(Constants.STATUS))) {
                    LOGGER.info("ForeignpayExchangesettlementOrderExecuter orderBatch redirectUrl:{}", (Object)responseData.getString("redirectUrl"));
                    resultListener.redirect(responseData, responseData.getString("redirectUrl"));
                    break block5;
                }
                throw new ResponseException(responseData);
            }
            catch (IOException e) {
                LOGGER.error("ForeignpayExchangesettlementOrderExecuter orderBatch responseData", (Throwable)e);
                throw new UnknownException(e);
            }
        }
    }

    public void queryBatch(JSONObject requestData, ResultListener resultListener) {
        LOGGER.info("ForeignpayExchangesettlementOrderExecuter queryBatch requestData:{}", (Object)requestData.toJSONString());
        String responseStr = HttpClientUtils.post(ConfigurationUtils.getForeignpayExchangesettlementQueryBatchUrl(), requestData.toJSONString());
        LOGGER.info("ForeignpayExchangesettlementOrderExecuter queryBatch responseStr:{}", (Object)responseStr);
        JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
        if (!StringUtils.isNotBlank((CharSequence)responseData.toJSONString())) {
            throw new NullPointerException("responseData is null");
        }
        this.verifyHmac(QUERY_BATCH_RESPONSE_HMAC_FILEDS, responseData);
        resultListener.success(responseData);
    }

    public void callback(JSONObject responseData, ResultListener resultListener) {
        LOGGER.info("ForeignpayExchangesettlementOrderExecuter callback responseData:{}", (Object)responseData.toJSONString());
        this.verifyHmac(QUERY_BATCH_RESPONSE_HMAC_FILEDS, responseData);
        String status = responseData.getString(Constants.STATUS);
        if (StringUtils.isNotBlank((CharSequence)status)) {
            if (Constants.SUCCESS.equals(status)) {
                resultListener.success(responseData);
            } else if (Constants.FAILED.equals(status) || Constants.CANCEL.equals(status)) {
                resultListener.failure(responseData);
            } else if (Constants.INIT.equals(status)) {
                resultListener.pending(responseData);
            } else {
                throw new ResponseException(responseData);
            }
        }
    }
}

