/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.eshopping.executer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.Constants;
import com.upay.sdk.HttpClientUtils;
import com.upay.sdk.core.CipherWrapper;
import com.upay.sdk.eshopping.builder.GetPolicyBuilder;
import com.upay.sdk.eshopping.builder.OrderBuilder;
import com.upay.sdk.eshopping.builder.PayBuilder;
import com.upay.sdk.eshopping.builder.QueryBuilder;
import com.upay.sdk.exception.ResponseException;
import com.upay.sdk.exception.UnknownException;
import com.upay.sdk.executer.Executer;
import com.upay.sdk.executer.ResultListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EshoppingExecuter
extends Executer {
    static final Logger LOGGER = LoggerFactory.getLogger(EshoppingExecuter.class);

    public void getPolicyV_3(GetPolicyBuilder builder, ResultListener resultListener) {
        LOGGER.debug("EshoppingExecuter getPolicyV_3 builder:[" + JSON.toJSONString((Object)builder) + "]");
        JSONObject requestData = builder.bothEncryptBuild();
        LOGGER.debug("EshoppingExecuter getPolicyV_3 requestData:[" + requestData.toJSONString() + "]");
        String responseStr = HttpClientUtils.post3(ConfigurationUtils.getEshoppingGetPolicyUrl(), requestData);
        LOGGER.debug("EshoppingExecuter getPolicyV_3 responseStr:[" + responseStr + "]");
        JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
        String status = responseData.getString(Constants.STATUS);
        if (Constants.ERROR.equals(status)) {
            throw new ResponseException(responseData);
        }
        responseData = CipherWrapper.bothDecryptWrap(responseData);
        LOGGER.debug("EshoppingExecuter getPolicyV_3 responseStr:[" + responseData + "]");
        this.bothVerifyHmacOrder(responseData);
        if (!Constants.SUCCESS.equals(responseData.getString(Constants.STATUS))) {
            throw new ResponseException(responseData);
        }
        resultListener.success(responseData);
    }

    public void orderV_3(OrderBuilder builder, ResultListener resultListener) {
        LOGGER.debug("EshoppingExecuter orderV_3 builder:[" + JSON.toJSONString((Object)builder) + "]");
        JSONObject requestData = builder.bothEncryptBuild();
        LOGGER.debug("EshoppingExecuter orderV_3 requestData:[" + requestData.toJSONString() + "]");
        String responseStr = HttpClientUtils.post3(ConfigurationUtils.getEshoppingOrderUrl(), requestData);
        LOGGER.debug("EshoppingExecuter orderV_3 responseStr:[" + responseStr + "]");
        JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
        String status = responseData.getString(Constants.STATUS);
        if (Constants.ERROR.equals(status)) {
            throw new ResponseException(responseData);
        }
        responseData = CipherWrapper.bothDecryptWrap(responseData);
        LOGGER.debug("responseStr:[" + responseData + "]");
        this.bothVerifyHmacOrder(responseData);
        if (!Constants.SUCCESS.equals(responseData.getString(Constants.STATUS))) {
            throw new ResponseException(responseData);
        }
        resultListener.success(responseData);
    }

    public void payV_3(PayBuilder builder, ResultListener resultListener) {
        LOGGER.debug("EshoppingExecuter payV_3 builder:[" + JSON.toJSONString((Object)builder) + "]");
        JSONObject requestData = builder.bothEncryptBuild();
        LOGGER.debug("EshoppingExecuter payV_3 requestData:[" + requestData.toJSONString() + "]");
        String responseStr = HttpClientUtils.post3(ConfigurationUtils.getEshoppingPayUrl(), requestData);
        LOGGER.debug("EshoppingExecuter payV_3 responseStr:[" + responseStr + "]");
        JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
        String status = responseData.getString(Constants.STATUS);
        if (Constants.ERROR.equals(status)) {
            throw new ResponseException(responseData);
        }
        responseData = CipherWrapper.bothDecryptWrap(responseData);
        LOGGER.debug("EshoppingExecuter payV_3 responseStr:[" + responseData + "]");
        this.bothVerifyHmacOrder(responseData);
        if (!Constants.SUCCESS.equals(responseData.getString(Constants.STATUS))) {
            throw new ResponseException(responseData);
        }
        resultListener.success(responseData);
    }

    public void callbackV_3(JSONObject responseData, ResultListener listener) {
        LOGGER.info("EshoppingExecuter callbackV_3 responseData:[" + responseData + "]");
        if (listener == null) {
            throw new NullPointerException();
        }
        JSONObject data = CipherWrapper.bothDecryptWrap(responseData);
        LOGGER.info("EshoppingExecuter callbackV_3 data:[" + data + "]");
        this.bothVerifyHmacOrder(data);
        JSONObject paymentJson = data.getJSONObject("ticketOrderVO");
        if (paymentJson != null) {
            String status = paymentJson.getString(Constants.STATUS);
            if (Constants.SUCCESS.equals(status)) {
                listener.success(data);
            } else {
                if (Constants.FAILED.equals(status) || Constants.CANCEL.equals(status)) {
                    listener.failure(data);
                    return;
                }
                if (Constants.INIT.equals(status)) {
                    listener.pending(data);
                    return;
                }
                throw new ResponseException(data);
            }
        }
        if (paymentJson == null) {
            LOGGER.info("EshoppingExecuter callbackV_3 do nothing.", (Object)responseData);
        }
    }

    public void queryV_3(QueryBuilder builder, ResultListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        try {
            JSONObject requestData = builder.bothEncryptBuild();
            LOGGER.debug("EshoppingExecuter queryV_3 requestData:[" + requestData + "]");
            String responseStr = HttpClientUtils.post3(ConfigurationUtils.getEshoppingQueryUrl(), requestData);
            JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
            LOGGER.debug("EshoppingExecuter queryV_3 responseStr:[" + responseStr + "]");
            this.callbackV_3(responseData, listener);
        }
        catch (Exception e) {
            LOGGER.error("EshoppingExecuter queryv_3 exception", (Throwable)e);
            throw new UnknownException(e);
        }
    }
}

