/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.ert.v_3.v2.builder;

import com.alibaba.fastjson.JSONObject;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.RSAUtils;
import com.upay.sdk.SignUtils;
import com.upay.sdk.builder.BuilderSupport;
import com.upay.sdk.core.CipherWrapper;
import com.upay.sdk.exception.UnknownException;

public final class MerchantSignUpBuilder
extends BuilderSupport {
    private String merchantId;
    private String requestId;
    private String signedName;
    private String shortName;
    private String email;
    private String businessAddress;
    private String province;
    private String city;
    private String legalPersonName;
    private String legalPersonIdNo;
    private String businessLicenseNo;
    private String cerEffectiveEndDate;
    private String mcc;
    private String bankCardNo;
    private String accountName;
    private String accountProvince;
    private String accountCity;
    private String idCardImgFrontUrl;
    private String idCardImgBackUrl;
    private String licenceUrl;
    private String cerUrl;
    private String otherUrl;
    private String registerRole;
    private String ip;
    private String registerType;
    private String microBizType;
    private String storeHeaderUrl;
    private String storeIndoorUrl;
    private String cerEffectiveStartDate;
    private String idEffectiveStartDate;
    private String idEffectiveEndDate;

    public MerchantSignUpBuilder setMerchantId(String merchantId) {
        this.merchantId = merchantId;
        return this;
    }

    public MerchantSignUpBuilder setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public MerchantSignUpBuilder setSignedName(String signedName) {
        this.signedName = signedName;
        return this;
    }

    public MerchantSignUpBuilder setShortName(String shortName) {
        this.shortName = shortName;
        return this;
    }

    public MerchantSignUpBuilder setEmail(String email) {
        this.email = email;
        return this;
    }

    public MerchantSignUpBuilder setBusinessAddress(String businessAddress) {
        this.businessAddress = businessAddress;
        return this;
    }

    public MerchantSignUpBuilder setProvince(String province) {
        this.province = province;
        return this;
    }

    public MerchantSignUpBuilder setCity(String city) {
        this.city = city;
        return this;
    }

    public MerchantSignUpBuilder setLegalPersonName(String legalPersonName) {
        this.legalPersonName = legalPersonName;
        return this;
    }

    public MerchantSignUpBuilder setLegalPersonIdNo(String legalPersonIdNo) {
        this.legalPersonIdNo = legalPersonIdNo;
        return this;
    }

    public MerchantSignUpBuilder setBusinessLicenseNo(String businessLicenseNo) {
        this.businessLicenseNo = businessLicenseNo;
        return this;
    }

    public MerchantSignUpBuilder setCerEffectiveEndDate(String cerEffectiveEndDate) {
        this.cerEffectiveEndDate = cerEffectiveEndDate;
        return this;
    }

    public MerchantSignUpBuilder setMcc(String mcc) {
        this.mcc = mcc;
        return this;
    }

    public MerchantSignUpBuilder setBankCardNo(String bankCardNo) {
        this.bankCardNo = bankCardNo;
        return this;
    }

    public MerchantSignUpBuilder setAccountName(String accountName) {
        this.accountName = accountName;
        return this;
    }

    public MerchantSignUpBuilder setAccountProvince(String accountProvince) {
        this.accountProvince = accountProvince;
        return this;
    }

    public MerchantSignUpBuilder setAccountCity(String accountCity) {
        this.accountCity = accountCity;
        return this;
    }

    public MerchantSignUpBuilder setIdCardImgFrontUrl(String idCardImgFrontUrl) {
        this.idCardImgFrontUrl = idCardImgFrontUrl;
        return this;
    }

    public MerchantSignUpBuilder setIdCardImgBackUrl(String idCardImgBackUrl) {
        this.idCardImgBackUrl = idCardImgBackUrl;
        return this;
    }

    public MerchantSignUpBuilder setLicenceUrl(String licenceUrl) {
        this.licenceUrl = licenceUrl;
        return this;
    }

    public MerchantSignUpBuilder setCerUrl(String cerUrl) {
        this.cerUrl = cerUrl;
        return this;
    }

    public MerchantSignUpBuilder setOtherUrl(String otherUrl) {
        this.otherUrl = otherUrl;
        return this;
    }

    public MerchantSignUpBuilder setRegisterRole(String registerRole) {
        this.registerRole = registerRole;
        return this;
    }

    public MerchantSignUpBuilder setIp(String ip) {
        this.ip = ip;
        return this;
    }

    public MerchantSignUpBuilder setRegisterType(String registerType) {
        this.registerType = registerType;
        return this;
    }

    public MerchantSignUpBuilder setMicroBizType(String microBizType) {
        this.microBizType = microBizType;
        return this;
    }

    public MerchantSignUpBuilder setStoreHeaderUrl(String storeHeaderUrl) {
        this.storeHeaderUrl = storeHeaderUrl;
        return this;
    }

    public MerchantSignUpBuilder setStoreIndoorUrl(String storeIndoorUrl) {
        this.storeIndoorUrl = storeIndoorUrl;
        return this;
    }

    public MerchantSignUpBuilder setCerEffectiveStartDate(String cerEffectiveStartDate) {
        this.cerEffectiveStartDate = cerEffectiveStartDate;
        return this;
    }

    public MerchantSignUpBuilder setIdEffectiveStartDate(String idEffectiveStartDate) {
        this.idEffectiveStartDate = idEffectiveStartDate;
        return this;
    }

    public MerchantSignUpBuilder setIdEffectiveEndDate(String idEffectiveEndDate) {
        this.idEffectiveEndDate = idEffectiveEndDate;
        return this;
    }

    @Override
    protected String orderGenerateHmac() {
        return SignUtils.signMd5(super.orderGenerateHmac(), ConfigurationUtils.getHmacKey(this.merchantId));
    }

    public JSONObject bothEncryptBuild() {
        JSONObject json = super.assembleBuild();
        try {
            json.put("hmac", (Object)this.bothOrderGenerateHmac());
        }
        catch (Exception e) {
            throw new UnknownException(e);
        }
        return CipherWrapper.bothEncryptWrap(this.merchantId, json);
    }

    protected byte[] bothOrderGenerateHmac() throws Exception {
        return RSAUtils.encryptSHA(super.orderGenerateHmac().getBytes("UTF-8"));
    }
}

