/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.ehb.builder;

import com.alibaba.fastjson.JSONObject;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.RSAUtils;
import com.upay.sdk.SignUtils;
import com.upay.sdk.builder.BuilderSupport;
import com.upay.sdk.core.CipherWrapper;
import com.upay.sdk.exception.UnknownException;

public final class MemberAuthBuilder
extends BuilderSupport {
    private String merchantId;
    private String username;
    private String appKey;
    private String notifyUrl;
    private String timeout;
    private String remark;

    public String getMerchantId() {
        return this.merchantId;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getAppKey() {
        return this.appKey;
    }

    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }

    public MemberAuthBuilder(String merchantId) {
        this.merchantId = merchantId;
    }

    public MemberAuthBuilder setMerchantId(String merchantId) {
        this.merchantId = merchantId;
        return this;
    }

    public MemberAuthBuilder setTimeout(String timeout) {
        this.timeout = timeout;
        return this;
    }

    public MemberAuthBuilder setRemark(String remark) {
        this.remark = remark;
        return this;
    }

    public JSONObject encryptBuild() {
        JSONObject json = super.assembleBuild();
        json.put("hmac", (Object)this.orderGenerateHmac());
        return CipherWrapper.encryptWrap(this.merchantId, json);
    }

    @Override
    protected String orderGenerateHmac() {
        String orderGenerateHmac = super.orderGenerateHmac();
        return SignUtils.signMd5(orderGenerateHmac, ConfigurationUtils.getHmacKey(this.merchantId));
    }

    public JSONObject bothEncryptBuild() {
        JSONObject json = super.assembleBuild();
        try {
            json.put("hmac", (Object)this.bothOrderGenerateHmac());
        }
        catch (Exception e) {
            throw new UnknownException(e);
        }
        return CipherWrapper.bothEncryptWrap(this.merchantId, json);
    }

    protected byte[] bothOrderGenerateHmac() throws Exception {
        return RSAUtils.encryptSHA(super.orderGenerateHmac().getBytes("UTF-8"));
    }
}

