/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.currencyexchange.executer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.Constants;
import com.upay.sdk.HttpClientUtils;
import com.upay.sdk.core.CipherWrapper;
import com.upay.sdk.currencyexchange.builder.CalculateFeeBuilder;
import com.upay.sdk.currencyexchange.builder.ExchangeConfirmBuilder;
import com.upay.sdk.currencyexchange.builder.ExchangeOrderBuilder;
import com.upay.sdk.currencyexchange.builder.PaymentAccountBuilder;
import com.upay.sdk.currencyexchange.builder.PaymentOrderAuditBuilder;
import com.upay.sdk.currencyexchange.builder.PaymentServiceFeeBuilder;
import com.upay.sdk.currencyexchange.builder.QueryAccountBalanceBuilder;
import com.upay.sdk.currencyexchange.builder.QueryAccountFlowBuilder;
import com.upay.sdk.currencyexchange.builder.QueryAccountInfoBuilder;
import com.upay.sdk.currencyexchange.builder.QueryExchangeInfoBuilder;
import com.upay.sdk.currencyexchange.builder.QueryQuotaBuilder;
import com.upay.sdk.currencyexchange.builder.QuerySettleDayBuilder;
import com.upay.sdk.currencyexchange.builder.WithdrawPayBuilder;
import com.upay.sdk.exception.ResponseException;
import com.upay.sdk.executer.Executer;
import com.upay.sdk.executer.ResultListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CurrencyExchangeExecuter
extends Executer {
    static final Logger LOGGER = LoggerFactory.getLogger(CurrencyExchangeExecuter.class);

    public void queryQuote(ExchangeOrderBuilder builder, ResultListener resultListener) {
        LOGGER.info("CurrencyExchangeExecuter queryQuote builder:[" + JSON.toJSONString((Object)builder) + "]");
        JSONObject requestData = builder.bothEncryptBuild();
        LOGGER.info("CurrencyExchangeExecuter queryQuote requestData:[" + requestData.toJSONString() + "]");
        String responseStr = HttpClientUtils.post3(ConfigurationUtils.getOceExchangeQueryQuote(), requestData);
        LOGGER.info("CurrencyExchangeExecuter queryQuote responseStr:[" + responseStr + "]");
        JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
        String status = responseData.getString(Constants.STATUS);
        if (Constants.ERROR.equals(status)) {
            throw new ResponseException(responseData);
        }
        responseData = CipherWrapper.bothDecryptWrap(responseData);
        LOGGER.info("CurrencyExchangeExecuter queryQuote responseStr:[" + responseData + "]");
        this.bothVerifyHmacOrder(responseData);
        if (!Constants.SUCCESS.equals(responseData.getString(Constants.STATUS))) {
            throw new ResponseException(responseData);
        }
        resultListener.success(responseData);
    }

    public void quoteConfirm(ExchangeConfirmBuilder builder, ResultListener resultListener) {
        LOGGER.info("CurrencyExchangeExecuter quoteConfirm builder:[" + JSON.toJSONString((Object)builder) + "]");
        JSONObject requestData = builder.bothEncryptBuild();
        LOGGER.info("CurrencyExchangeExecuter quoteConfirm requestData:[" + requestData.toJSONString() + "]");
        String responseStr = HttpClientUtils.post3(ConfigurationUtils.getOceExchangeConfirm(), requestData);
        LOGGER.info("CurrencyExchangeExecuter quoteConfirm responseStr:[" + responseStr + "]");
        JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
        String status = responseData.getString(Constants.STATUS);
        if (Constants.ERROR.equals(status)) {
            throw new ResponseException(responseData);
        }
        responseData = CipherWrapper.bothDecryptWrap(responseData);
        LOGGER.info("CurrencyExchangeExecuter quoteConfirm responseStr:[" + responseData + "]");
        this.bothVerifyHmacOrder(responseData);
        if (!Constants.SUCCESS.equals(responseData.getString(Constants.STATUS))) {
            throw new ResponseException(responseData);
        }
        resultListener.success(responseData);
    }

    public void quoteInfo(QueryExchangeInfoBuilder builder, ResultListener resultListener) {
        LOGGER.info("CurrencyExchangeExecuter quoteInfo builder:[" + JSON.toJSONString((Object)builder) + "]");
        JSONObject requestData = builder.bothEncryptBuild();
        LOGGER.info("CurrencyExchangeExecuter quoteInfo requestData:[" + requestData.toJSONString() + "]");
        String responseStr = HttpClientUtils.post3(ConfigurationUtils.getOceQuoteInfo(), requestData);
        LOGGER.info("CurrencyExchangeExecuter quoteInfo responseStr:[" + responseStr + "]");
        JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
        String status = responseData.getString(Constants.STATUS);
        if (Constants.ERROR.equals(status)) {
            throw new ResponseException(responseData);
        }
        responseData = CipherWrapper.bothDecryptWrap(responseData);
        LOGGER.info("CurrencyExchangeExecuter quoteInfo responseStr:[" + responseData + "]");
        this.bothVerifyHmacOrder(responseData);
        if (!Constants.SUCCESS.equals(responseData.getString(Constants.STATUS))) {
            throw new ResponseException(responseData);
        }
        resultListener.success(responseData);
    }

    public void addPaymentAccount(PaymentAccountBuilder builder, ResultListener resultListener) {
        LOGGER.info("CurrencyExchangeExecuter addPaymentAccount builder:[" + JSON.toJSONString((Object)builder) + "]");
        JSONObject requestData = builder.bothEncryptBuild();
        LOGGER.info("CurrencyExchangeExecuter addPaymentAccount requestData:[" + requestData.toJSONString() + "]");
        String responseStr = HttpClientUtils.post3(ConfigurationUtils.getOceAddPaymentAccount(), requestData);
        LOGGER.info("CurrencyExchangeExecuter addPaymentAccount responseStr:[" + responseStr + "]");
        JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
        String status = responseData.getString(Constants.STATUS);
        if (Constants.ERROR.equals(status)) {
            throw new ResponseException(responseData);
        }
        responseData = CipherWrapper.bothDecryptWrap(responseData);
        LOGGER.info("CurrencyExchangeExecuter addPaymentAccount responseStr:[" + responseData + "]");
        this.bothVerifyHmacOrder(responseData);
        if (!Constants.SUCCESS.equals(responseData.getString(Constants.STATUS))) {
            throw new ResponseException(responseData);
        }
        resultListener.success(responseData);
    }

    public void queryPaymentAccountInfo(QueryAccountInfoBuilder builder, ResultListener resultListener) {
        LOGGER.info("CurrencyExchangeExecuter queryPaymentAccountInfo builder:[" + JSON.toJSONString((Object)builder) + "]");
        JSONObject requestData = builder.bothEncryptBuild();
        LOGGER.info("CurrencyExchangeExecuter queryPaymentAccountInfo requestData:[" + requestData.toJSONString() + "]");
        String responseStr = HttpClientUtils.post3(ConfigurationUtils.getOcePaymentAccountInfo(), requestData);
        LOGGER.info("CurrencyExchangeExecuter queryPaymentAccountInfo responseStr:[" + responseStr + "]");
        JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
        String status = responseData.getString(Constants.STATUS);
        if (Constants.ERROR.equals(status)) {
            throw new ResponseException(responseData);
        }
        responseData = CipherWrapper.bothDecryptWrap(responseData);
        LOGGER.info("CurrencyExchangeExecuter queryPaymentAccountInfo responseStr:[" + responseData + "]");
        this.bothVerifyHmacOrder(responseData);
        if (!Constants.SUCCESS.equals(responseData.getString(Constants.STATUS))) {
            throw new ResponseException(responseData);
        }
        resultListener.success(responseData);
    }

    public void calculateFee(CalculateFeeBuilder builder, ResultListener resultListener) {
        LOGGER.info("CurrencyExchangeExecuter calculateFee builder:[" + JSON.toJSONString((Object)builder) + "]");
        JSONObject requestData = builder.bothEncryptBuild();
        LOGGER.info("CurrencyExchangeExecuter calculateFee requestData:[" + requestData.toJSONString() + "]");
        String responseStr = HttpClientUtils.post3(ConfigurationUtils.getOceCalculateFee(), requestData);
        LOGGER.info("CurrencyExchangeExecuter calculateFee responseStr:[" + responseStr + "]");
        JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
        String status = responseData.getString(Constants.STATUS);
        if (Constants.ERROR.equals(status)) {
            throw new ResponseException(responseData);
        }
        responseData = CipherWrapper.bothDecryptWrap(responseData);
        LOGGER.info("CurrencyExchangeExecuter calculateFee responseStr:[" + responseData + "]");
        this.bothVerifyHmacOrder(responseData);
        if (!Constants.SUCCESS.equals(responseData.getString(Constants.STATUS))) {
            throw new ResponseException(responseData);
        }
        resultListener.success(responseData);
    }

    public void queryAccountBalance(QueryAccountBalanceBuilder builder, ResultListener resultListener) {
        LOGGER.info("CurrencyExchangeExecuter queryAccountBalance builder:[" + JSON.toJSONString((Object)builder) + "]");
        JSONObject requestData = builder.bothEncryptBuild();
        LOGGER.info("CurrencyExchangeExecuter queryAccountBalance requestData:[" + requestData.toJSONString() + "]");
        String responseStr = HttpClientUtils.post3(ConfigurationUtils.getOceAccountBalance(), requestData);
        LOGGER.info("CurrencyExchangeExecuter queryAccountBalance responseStr:[" + responseStr + "]");
        JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
        String status = responseData.getString(Constants.STATUS);
        if (Constants.ERROR.equals(status)) {
            throw new ResponseException(responseData);
        }
        responseData = CipherWrapper.bothDecryptWrap(responseData);
        LOGGER.info("CurrencyExchangeExecuter queryAccountBalance responseStr:[" + responseData + "]");
        this.bothVerifyHmacOrder(responseData);
        if (!Constants.SUCCESS.equals(responseData.getString(Constants.STATUS))) {
            throw new ResponseException(responseData);
        }
        resultListener.success(responseData);
    }

    public void queryAccountFlow(QueryAccountFlowBuilder builder, ResultListener resultListener) {
        LOGGER.info("CurrencyExchangeExecuter queryAccountFlow builder:[" + JSON.toJSONString((Object)builder) + "]");
        JSONObject requestData = builder.bothEncryptBuild();
        LOGGER.info("CurrencyExchangeExecuter queryAccountFlow requestData:[" + requestData.toJSONString() + "]");
        String responseStr = HttpClientUtils.post3(ConfigurationUtils.getOceAccountFlow(), requestData);
        LOGGER.info("CurrencyExchangeExecuter queryAccountFlow responseStr:[" + responseStr + "]");
        JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
        String status = responseData.getString(Constants.STATUS);
        if (Constants.ERROR.equals(status)) {
            throw new ResponseException(responseData);
        }
        responseData = CipherWrapper.bothDecryptWrap(responseData);
        LOGGER.info("CurrencyExchangeExecuter queryAccountFlow responseStr:[" + responseData + "]");
        this.bothVerifyHmacOrder(responseData);
        if (!Constants.SUCCESS.equals(responseData.getString(Constants.STATUS))) {
            throw new ResponseException(responseData);
        }
        resultListener.success(responseData);
    }

    public void queryAccountQuota(QueryQuotaBuilder builder, ResultListener resultListener) {
        LOGGER.info("CurrencyExchangeExecuter queryAccountQuota builder:[" + JSON.toJSONString((Object)builder) + "]");
        JSONObject requestData = builder.bothEncryptBuild();
        LOGGER.info("CurrencyExchangeExecuter queryAccountQuota requestData:[" + requestData.toJSONString() + "]");
        String responseStr = HttpClientUtils.post3(ConfigurationUtils.getOceAccountQuota(), requestData);
        LOGGER.info("CurrencyExchangeExecuter queryAccountQuota responseStr:[" + responseStr + "]");
        JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
        String status = responseData.getString(Constants.STATUS);
        if (Constants.ERROR.equals(status)) {
            throw new ResponseException(responseData);
        }
        responseData = CipherWrapper.bothDecryptWrap(responseData);
        LOGGER.info("CurrencyExchangeExecuter queryAccountQuota responseStr:[" + responseData + "]");
        this.bothVerifyHmacOrder(responseData);
        if (!Constants.SUCCESS.equals(responseData.getString(Constants.STATUS))) {
            throw new ResponseException(responseData);
        }
        resultListener.success(responseData);
    }

    public void withdrawPay(WithdrawPayBuilder builder, ResultListener resultListener) {
        LOGGER.info("CurrencyExchangeExecuter withdrawPay builder:[" + JSON.toJSONString((Object)builder) + "]");
        JSONObject requestData = builder.bothEncryptBuild();
        LOGGER.info("CurrencyExchangeExecuter withdrawPay requestData:[" + requestData.toJSONString() + "]");
        String responseStr = HttpClientUtils.post3(ConfigurationUtils.getOceWithdrawPay(), requestData);
        LOGGER.info("CurrencyExchangeExecuter withdrawPay responseStr:[" + responseStr + "]");
        JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
        String status = responseData.getString(Constants.STATUS);
        if (Constants.ERROR.equals(status)) {
            throw new ResponseException(responseData);
        }
        responseData = CipherWrapper.bothDecryptWrap(responseData);
        LOGGER.info("CurrencyExchangeExecuter withdrawPay responseStr:[" + responseData + "]");
        this.bothVerifyHmacOrder(responseData);
        if (!Constants.SUCCESS.equals(responseData.getString(Constants.STATUS))) {
            throw new ResponseException(responseData);
        }
        resultListener.success(responseData);
    }

    public void settleDay(QuerySettleDayBuilder builder, ResultListener resultListener) {
        LOGGER.info("CurrencyExchangeExecuter holiday builder:[" + JSON.toJSONString((Object)builder) + "]");
        JSONObject requestData = builder.bothEncryptBuild();
        LOGGER.info("CurrencyExchangeExecuter holiday requestData:[" + requestData.toJSONString() + "]");
        String responseStr = HttpClientUtils.post3(ConfigurationUtils.getOceSettleDay(), requestData);
        LOGGER.info("CurrencyExchangeExecuter holiday responseStr:[" + responseStr + "]");
        JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
        String status = responseData.getString(Constants.STATUS);
        if (Constants.ERROR.equals(status)) {
            throw new ResponseException(responseData);
        }
        responseData = CipherWrapper.bothDecryptWrap(responseData);
        LOGGER.info("CurrencyExchangeExecuter holiday responseStr:[" + responseData + "]");
        this.bothVerifyHmacOrder(responseData);
        if (!Constants.SUCCESS.equals(responseData.getString(Constants.STATUS))) {
            throw new ResponseException(responseData);
        }
        resultListener.success(responseData);
    }

    public void paymentServiceFee(PaymentServiceFeeBuilder builder, ResultListener resultListener) {
        LOGGER.info("CurrencyExchangeExecuter paymentServiceFee builder:[" + JSON.toJSONString((Object)builder) + "]");
        JSONObject requestData = builder.bothEncryptBuild();
        LOGGER.info("CurrencyExchangeExecuter paymentServiceFee requestData:[" + requestData.toJSONString() + "]");
        String responseStr = HttpClientUtils.post3(ConfigurationUtils.getOcePaymentServiceFee(), requestData);
        LOGGER.info("CurrencyExchangeExecuter paymentServiceFee responseStr:[" + responseStr + "]");
        JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
        String status = responseData.getString(Constants.STATUS);
        if (Constants.ERROR.equals(status)) {
            throw new ResponseException(responseData);
        }
        responseData = CipherWrapper.bothDecryptWrap(responseData);
        LOGGER.info("CurrencyExchangeExecuter paymentServiceFee responseStr:[" + responseData + "]");
        this.bothVerifyHmacOrder(responseData);
        if (!Constants.SUCCESS.equals(responseData.getString(Constants.STATUS))) {
            throw new ResponseException(responseData);
        }
        resultListener.success(responseData);
    }

    public void paymentOrderAudit(PaymentOrderAuditBuilder builder, ResultListener resultListener) {
        LOGGER.info("CurrencyExchangeExecuter paymentServiceFee builder:[" + JSON.toJSONString((Object)builder) + "]");
        JSONObject requestData = builder.bothEncryptBuild();
        LOGGER.info("CurrencyExchangeExecuter paymentServiceFee requestData:[" + requestData.toJSONString() + "]");
        String responseStr = HttpClientUtils.post3(ConfigurationUtils.getOcePaymentOrderAuditUrl(), requestData);
        LOGGER.info("CurrencyExchangeExecuter paymentServiceFee responseStr:[" + responseStr + "]");
        JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
        String status = responseData.getString(Constants.STATUS);
        if (Constants.ERROR.equals(status)) {
            throw new ResponseException(responseData);
        }
        responseData = CipherWrapper.bothDecryptWrap(responseData);
        LOGGER.info("CurrencyExchangeExecuter paymentServiceFee responseStr:[" + responseData + "]");
        this.bothVerifyHmacOrder(responseData);
        if (!Constants.SUCCESS.equals(responseData.getString(Constants.STATUS))) {
            throw new ResponseException(responseData);
        }
        resultListener.success(responseData);
    }

    public void bothOceCallback(JSONObject responseData, ResultListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        JSONObject data = CipherWrapper.bothDecryptWrap(responseData);
        this.bothVerifyHmacOrder(data);
        listener.success(data);
    }
}

