/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.crypto;

import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.core.Environment;
import com.upay.sdk.crypto.CertificateReader;
import com.upay.sdk.crypto.codec.Base64;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class CertificateReaderAdapter
implements CertificateReader {
    private static final Map<String, String> privateKeyCache = new ConcurrentHashMap<String, String>();
    private static final Map<String, String> publicKeyCache = new ConcurrentHashMap<String, String>();

    private static byte[] parseBase64Data(byte[] data) {
        while (data != null && data.length > 0 && !new String(data, Environment.DEFAULT_CHARSET).trim().startsWith("-----BEGIN") && Base64.isBase64(data)) {
            data = Base64.decode(data);
        }
        return data;
    }

    private static byte[] readFileOrBase64(String pathOrBase64) {
        byte[] data;
        if (Base64.isBase64(pathOrBase64)) {
            data = CertificateReaderAdapter.parseBase64Data(pathOrBase64.getBytes(Environment.DEFAULT_CHARSET));
        } else {
            try {
                data = Files.readAllBytes(Paths.get(pathOrBase64, new String[0]));
                data = CertificateReaderAdapter.parseBase64Data(data);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return data;
    }

    private byte[] getPrivateKeyData(String merchantId) {
        String keyPath = ConfigurationUtils.getClientPrivateKeyPath(merchantId);
        if (keyPath == null || keyPath.trim().isEmpty()) {
            throw new IllegalArgumentException("no private key configuration , merchantId:[" + merchantId + "]");
        }
        return CertificateReaderAdapter.readFileOrBase64(keyPath);
    }

    @Override
    public String readPrivateKey(String merchantId) throws Exception {
        return privateKeyCache.computeIfAbsent(merchantId, key -> {
            byte[] data = this.getPrivateKeyData(merchantId);
            String password = ConfigurationUtils.getClientPrivateKeyPassword(merchantId);
            char[] pwd = this.getPasswordChars(password);
            return this.parsePrivateKey(data, pwd);
        });
    }

    @Override
    public String readPublicKey(String merchantId) throws Exception {
        return publicKeyCache.computeIfAbsent(merchantId, key -> {
            String path = ConfigurationUtils.getServerPublicKey(merchantId);
            if (path == null || path.trim().isEmpty()) {
                return this.getDefaultPublicKey();
            }
            return this.parsePublicKey(CertificateReaderAdapter.readFileOrBase64(path));
        });
    }

    @Override
    public boolean canParsePrivateKey(String merchantId) {
        String password = ConfigurationUtils.getClientPrivateKeyPassword(merchantId);
        char[] pwd = this.getPasswordChars(password);
        return this.canParsePrivateKey(this.getPrivateKeyData(merchantId), pwd);
    }

    private char[] getPasswordChars(String password) {
        return password != null && !password.trim().isEmpty() ? password.toCharArray() : null;
    }

    protected abstract String parsePrivateKey(byte[] var1, char[] var2);

    protected abstract boolean canParsePrivateKey(byte[] var1, char[] var2);

    protected abstract String parsePublicKey(byte[] var1);

    protected abstract String getDefaultPublicKey();
}

