/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.consumerFinance.v_2.builder;

import com.alibaba.fastjson.JSONObject;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.SignUtils;
import com.upay.sdk.builder.BuilderSupport;
import com.upay.sdk.core.CipherWrapper;
import org.apache.commons.lang3.StringUtils;

public class RepaymentQueryBuilder
extends BuilderSupport {
    private String merchantId;
    private String requestId;

    public RepaymentQueryBuilder(String merchantId) {
        this.merchantId = merchantId;
    }

    public RepaymentQueryBuilder setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public JSONObject build() {
        JSONObject json = super.build(this.merchantId);
        if (StringUtils.isNotBlank((CharSequence)this.requestId)) {
            json.put("requestId", (Object)this.requestId);
        }
        return json;
    }

    public JSONObject encryptBuild() {
        JSONObject json = super.assembleBuild();
        json.put("hmac", (Object)this.orderGenerateHmac());
        return CipherWrapper.encryptWrap(this.merchantId, json);
    }

    @Override
    protected String orderGenerateHmac() {
        String orderGenerateHmac = super.orderGenerateHmac();
        String hmacKey = ConfigurationUtils.getHmacKey(this.merchantId);
        return SignUtils.signMd5(orderGenerateHmac, hmacKey);
    }
}

