/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.cashier.eaccount.executer;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.Constants;
import com.upay.sdk.HttpClientUtils;
import com.upay.sdk.cashier.eaccount.builder.ExclusiveAccountQueryBuilder;
import com.upay.sdk.core.CipherWrapper;
import com.upay.sdk.exception.ResponseException;
import com.upay.sdk.exception.UnknownException;
import com.upay.sdk.executer.Executer;
import com.upay.sdk.executer.ResultListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExclusiveAccountExecuter
extends Executer {
    static final Logger LOGGER = LoggerFactory.getLogger(ExclusiveAccountExecuter.class);

    public void bothExclusiveAccountQuery(ExclusiveAccountQueryBuilder builder, ResultListener resultListener) {
        block5: {
            try {
                JSONObject requestData = builder.bothEncryptBuild();
                LOGGER.info("bothExclusiveAccountQuery requestData:[" + requestData.toJSONString() + "]");
                String responseStr = HttpClientUtils.post3(ConfigurationUtils.getCashierExclusiveAccountQueryUrl(), requestData);
                LOGGER.info("bothExclusiveAccountQuery responseStr:[" + responseStr + "]");
                JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
                responseData = CipherWrapper.bothDecryptWrap(responseData);
                LOGGER.info("bothExclusiveAccountQuery responseStr:[" + responseData + "]");
                String status = responseData.getString(Constants.STATUS);
                if (Constants.ERROR.equals(status)) {
                    throw new ResponseException(responseData);
                }
                this.bothVerifyHmacOrder(responseData);
                if (Constants.SUCCESS.equals(status)) {
                    resultListener.success(responseData);
                    break block5;
                }
                if (Constants.FAILED.equals(status)) {
                    resultListener.failure(responseData);
                    break block5;
                }
                throw new ResponseException(responseData);
            }
            catch (Exception e) {
                LOGGER.error("bothExclusiveAccountQuery error", (Throwable)e);
                throw new UnknownException(e);
            }
        }
    }
}

