package com.upay.sdk.exception;

import com.alibaba.fastjson.JSONObject;

public abstract class ExceptionHandlerForMobile {

    public static void handle(final JSONObject responseData, Exception e) {
        if (e instanceof ResponseException) {
            responseData.put("status", "EXCEPTION");
            responseData.put("exceptionCode", "response.exception");
            responseData.put("message", "响应异常");
        }
        if (e instanceof HmacVerifyException) {
            responseData.put("status", "EXCEPTION");
            responseData.put("exceptionCode", "hmac_verify.exception");
            responseData.put("message", "签名验证异常");
        }
        if (e instanceof RequestException) {
            responseData.put("status", "EXCEPTION");
            responseData.put("exceptionCode", "request.exception");
            responseData.put("message", "请求异常");
        }
        if (e instanceof UnknownException || e instanceof Exception) {
            responseData.put("status", "EXCEPTION");
            responseData.put("exceptionCode", "unknown.exception");
            responseData.put("message", "未知异常");
        }
    }
}
