package com.upay.sdk.eaccount.executer;/**
 * <p>
 * 功能描述
 * <p/>
 *
 * @date: 2023-09-27 19:10<br/>
 * @author Administrator
 * @since JDK 1.8
 */

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.Constants;
import com.upay.sdk.HttpClientUtils;
import com.upay.sdk.core.CipherWrapper;
import com.upay.sdk.eaccount.builder.EaccountQueryBuilder;
import com.upay.sdk.exception.ResponseException;
import com.upay.sdk.exception.UnknownException;
import com.upay.sdk.executer.Executer;
import com.upay.sdk.executer.ResultListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 功能描述: <br/>
 *
 * @author Administrator
 * @date: 2023-09-27 19:10<br/>
 * @date: 19:10<br/>
 * @since JDK 1.8
 */
public class EaccountExecuter extends Executer {

    static final Logger LOGGER = LoggerFactory.getLogger(EaccountExecuter.class);

    public EaccountExecuter() {
    }

    public void eaccountQuery(EaccountQueryBuilder builder, ResultListener resultListener) {
        try {
            JSONObject requestData = builder.bothEncryptBuild();
            LOGGER.debug("EaccountExecuter requestData:[" + requestData.toJSONString() + "]");
            String eaccountQueryUrl = ConfigurationUtils.getValue("eaccount.query.url");
            LOGGER.info("EaccountExecuter url:[" + eaccountQueryUrl + "]");
            String responseStr = HttpClientUtils.post3(eaccountQueryUrl, requestData);
            LOGGER.info("EaccountExecuter responseStr:[" + responseStr + "]");
            JSONObject responseData = JSONObject.parseObject(responseStr, new Feature[]{Feature.SortFeidFastMatch});
            responseData = CipherWrapper.bothDecryptWrap(responseData);
            LOGGER.info("EaccountExecuter responseData:[" + responseData + "]");
            String status = responseData.getString(Constants.STATUS);
            if (Constants.ERROR.equals(status)) {
                throw new ResponseException(responseData);
            } else {
                this.bothVerifyHmacOrder(responseData);
                if (Constants.SUCCESS.equals(status)) {
                    resultListener.success(responseData);
                } else {
                    if (!Constants.FAILED.equals(status)) {
                        throw new ResponseException(responseData);
                    }

                    resultListener.failure(responseData);
                }
            }
        } catch (Exception expt) {
            LOGGER.error("EaccountExecuter error", expt);
            throw new UnknownException(expt);
        }
    }
}