package com.upay.sdk.eaccount.builder;/**
 * <p>
 * 功能描述
 * <p/>
 *
 * @date: 2023-09-27 18:41<br/>
 * @author Administrator
 * @since JDK 1.8
 */

import com.alibaba.fastjson.JSONObject;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.RSAUtils;
import com.upay.sdk.SignUtils;
import com.upay.sdk.builder.BuilderSupport;
import com.upay.sdk.core.CipherWrapper;
import com.upay.sdk.exception.UnknownException;
import org.apache.commons.lang3.StringUtils;

public class EaccountQueryBuilder extends BuilderSupport {

    private String merchantId;
    private String partnerId;
    private String rechargeType;

    public String getMerchantId() {
        return merchantId;
    }

    public String getPartnerId() {
        return partnerId;
    }

    public String getRechargeType() {
        return rechargeType;
    }


    public void setMerchantId(String merchantId) {
        this.merchantId = merchantId;
    }

    public void setPartnerId(String partnerId) {
        this.partnerId = partnerId;
    }

    public void setRechargeType(String rechargeType) {
        this.rechargeType = rechargeType;
    }

    public EaccountQueryBuilder(String merchantId) {
        this.merchantId = merchantId;
    }


    protected String orderGenerateHmac() {
        return SignUtils.signMd5(super.orderGenerateHmac(), ConfigurationUtils.getHmacKey(this.merchantId));
    }

    public JSONObject encryptBuild() {
        JSONObject json = super.assembleBuild();
        json.put("hmac", this.orderGenerateHmac());
        return StringUtils.isNotBlank(this.partnerId) ? CipherWrapper.bothEncryptWrap(this.merchantId, this.partnerId, json) : CipherWrapper.encryptWrap(this.merchantId, json);
    }

    public JSONObject bothEncryptBuild() {
        JSONObject json = super.assembleBuild();

        try {
            json.put("hmac", this.bothOrderGenerateHmac());
        } catch (Exception var3) {
            throw new UnknownException(var3);
        }

        return StringUtils.isNotBlank(this.partnerId) ? CipherWrapper.bothEncryptWrap(this.merchantId, this.partnerId, json) : CipherWrapper.bothEncryptWrap(this.merchantId, json);
    }

    protected byte[] bothOrderGenerateHmac() throws Exception {
        return RSAUtils.encryptSHA(super.orderGenerateHmac().getBytes("UTF-8"));
    }


}