/*
 * Project Name:upay-sdk-web
 * File Name:QueryServlet.java
 * Package Name:com.upay.sdk.onlinepay.v_2.QueryServlet
 * Date:2016-08-15 15:53:11
 * Copyright (c) 2016, upay All Rights Reserved.
 */

package com.upay.sdk.eaccount;

import com.alibaba.fastjson.JSONObject;
import com.upay.sdk.eaccount.builder.EaccountQueryBuilder;
import com.upay.sdk.eaccount.executer.EaccountExecuter;
import com.upay.sdk.exception.HmacVerifyException;
import com.upay.sdk.exception.RequestException;
import com.upay.sdk.exception.ResponseException;
import com.upay.sdk.exception.UnknownException;
import com.upay.sdk.executer.ResultListenerAdpater;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class EaccountQueryServlet extends HttpServlet {

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        doPost(req, resp);
    }

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        //商户编号
        String merchantId = req.getParameter("merchantId");
        //服务商编号
        String partnerId = req.getParameter("partnerId");
        //充值类型
        String rechargeType = req.getParameter("rechargeType");

        EaccountQueryBuilder builder = new EaccountQueryBuilder(merchantId);
        builder.setPartnerId(partnerId);
        builder.setRechargeType(rechargeType);

        final PrintWriter out = resp.getWriter();
        EaccountExecuter executer = new EaccountExecuter();
        try {
            executer.eaccountQuery(builder, new ResultListenerAdpater() {
                @Override
                public void success(JSONObject jsonObject) {
                    out.println("处理成功！<br/>");
                    String result = jsonObject.toJSONString();
                    out.print(result);
                }

                @Override
                public void failure(JSONObject jsonObject) {
                    out.println("处理失败！<br/>");
                    String result = jsonObject.toJSONString();
                    out.print(result);
                }

                @Override
                public void pending(JSONObject jsonObject) {
                    out.println("待处理！<br/>");
                    String result = jsonObject.toJSONString();
                    out.print(result);
                }
            });
        } catch (ResponseException e) {
            out.println("响应异常</br>");
            out.println(e.toString());
        } catch (HmacVerifyException e) {
            out.println("签名验证异常</br>");
            out.println(e.toString());
        } catch (RequestException e) {
            out.println("请求异常</br>");
            out.println(e.toString());
        } catch (UnknownException e) {
            out.println("未知异常</br>");
            out.println(e.toString());
        }
    }
}
