/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.webox.executer;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.Constants;
import com.upay.sdk.HttpClientUtils;
import com.upay.sdk.core.CipherWrapper;
import com.upay.sdk.exception.ResponseException;
import com.upay.sdk.exception.UnknownException;
import com.upay.sdk.executer.Executer;
import com.upay.sdk.executer.ResultListener;
import com.upay.sdk.webox.builder.BillDetailQueryBuilder;
import com.upay.sdk.webox.builder.BillQueryBuilder;
import com.upay.sdk.webox.builder.RedPacketBillQueryBuilder;
import com.upay.sdk.webox.builder.TradeDeleteBuilder;
import com.upay.sdk.webox.builder.TradeRecordBuilder;
import com.upay.sdk.webox.builder.TradeStatBuilder;
import com.upay.sdk.webox.builder.TradeStatisBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TradeRecordExecuter
extends Executer {
    static final Logger LOGGER = LoggerFactory.getLogger(TradeRecordExecuter.class);

    public void bothQuery(TradeRecordBuilder builder, ResultListener resultListener) {
        block6: {
            try {
                JSONObject requestData = builder.bothEncryptBuild();
                LOGGER.debug("bothQuery requestData:[" + requestData.toJSONString() + "]");
                String responseStr = HttpClientUtils.post3(ConfigurationUtils.getWeboxTradeRecordQueryUrl(), requestData);
                LOGGER.info("bothQuery responseStr:[" + responseStr + "]");
                JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
                responseData = CipherWrapper.bothDecryptWrap(responseData);
                LOGGER.info("responseStr:[" + responseData + "]");
                if (null == responseData) {
                    throw new ResponseException(responseData);
                }
                String status = responseData.getString(Constants.STATUS);
                if (Constants.ERROR.equals(status)) {
                    throw new ResponseException(responseData);
                }
                this.bothVerifyHmacOrder(responseData);
                if (Constants.SUCCESS.equals(status)) {
                    resultListener.success(responseData);
                    break block6;
                }
                if (Constants.FAILED.equals(status)) {
                    resultListener.failure(responseData);
                    break block6;
                }
                throw new ResponseException(responseData);
            }
            catch (Exception e) {
                LOGGER.error("bothQuery error", (Throwable)e);
                throw new UnknownException(e);
            }
        }
    }

    public void bothStat(TradeStatBuilder builder, ResultListener resultListener) {
        block6: {
            try {
                JSONObject requestData = builder.bothEncryptBuild();
                LOGGER.debug("bothStatis requestData:[" + requestData.toJSONString() + "]");
                String responseStr = HttpClientUtils.post3(ConfigurationUtils.getWeboxTradeStatUrl(), requestData);
                LOGGER.info("bothStatis responseStr:[" + responseStr + "]");
                JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
                responseData = CipherWrapper.bothDecryptWrap(responseData);
                LOGGER.info("responseStr:[" + responseData + "]");
                if (null == responseData) {
                    throw new ResponseException(responseData);
                }
                String status = responseData.getString(Constants.STATUS);
                if (Constants.ERROR.equals(status)) {
                    throw new ResponseException(responseData);
                }
                this.bothVerifyHmacOrder(responseData);
                if (Constants.SUCCESS.equals(status)) {
                    resultListener.success(responseData);
                    break block6;
                }
                if (Constants.FAILED.equals(status)) {
                    resultListener.failure(responseData);
                    break block6;
                }
                throw new ResponseException(responseData);
            }
            catch (Exception e) {
                LOGGER.error("bothStatis error", (Throwable)e);
                throw new UnknownException(e);
            }
        }
    }

    public void bothStatRedpacket(TradeStatBuilder builder, ResultListener resultListener) {
        block6: {
            try {
                JSONObject requestData = builder.bothEncryptBuild();
                LOGGER.debug("bothStatis requestData:[" + requestData.toJSONString() + "]");
                String responseStr = HttpClientUtils.post3(ConfigurationUtils.getWeboxRedpacketTradeStatUrl(), requestData);
                LOGGER.info("bothStatis responseStr:[" + responseStr + "]");
                JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
                responseData = CipherWrapper.bothDecryptWrap(responseData);
                LOGGER.info("responseStr:[" + responseData + "]");
                if (null == responseData) {
                    throw new ResponseException(responseData);
                }
                String status = responseData.getString(Constants.STATUS);
                if (Constants.ERROR.equals(status)) {
                    throw new ResponseException(responseData);
                }
                this.bothVerifyHmacOrder(responseData);
                if (Constants.SUCCESS.equals(status)) {
                    resultListener.success(responseData);
                    break block6;
                }
                if (Constants.FAILED.equals(status)) {
                    resultListener.failure(responseData);
                    break block6;
                }
                throw new ResponseException(responseData);
            }
            catch (Exception e) {
                LOGGER.error("bothStatis error", (Throwable)e);
                throw new UnknownException(e);
            }
        }
    }

    public void bothStatis(TradeStatisBuilder builder, ResultListener resultListener) {
        block6: {
            try {
                JSONObject requestData = builder.bothEncryptBuild();
                LOGGER.debug("bothStatis requestData:[" + requestData.toJSONString() + "]");
                String responseStr = HttpClientUtils.post3(ConfigurationUtils.getWeboxTradeStatisUrl(), requestData);
                LOGGER.info("bothStatis responseStr:[" + responseStr + "]");
                JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
                responseData = CipherWrapper.bothDecryptWrap(responseData);
                LOGGER.info("responseStr:[" + responseData + "]");
                if (null == responseData) {
                    throw new ResponseException(responseData);
                }
                String status = responseData.getString(Constants.STATUS);
                if (Constants.ERROR.equals(status)) {
                    throw new ResponseException(responseData);
                }
                this.bothVerifyHmacOrder(responseData);
                if (Constants.SUCCESS.equals(status)) {
                    resultListener.success(responseData);
                    break block6;
                }
                if (Constants.FAILED.equals(status)) {
                    resultListener.failure(responseData);
                    break block6;
                }
                throw new ResponseException(responseData);
            }
            catch (Exception e) {
                LOGGER.error("bothStatis error", (Throwable)e);
                throw new UnknownException(e);
            }
        }
    }

    public void bothDelete(TradeDeleteBuilder builder, ResultListener resultListener) {
        block6: {
            try {
                JSONObject requestData = builder.bothEncryptBuild();
                LOGGER.debug("bothDelete requestData:[" + requestData.toJSONString() + "]");
                String responseStr = HttpClientUtils.post3(ConfigurationUtils.getWeboxTradeRecordDeleteUrl(), requestData);
                LOGGER.info("bothDelete responseStr:[" + responseStr + "]");
                JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
                responseData = CipherWrapper.bothDecryptWrap(responseData);
                LOGGER.info("responseStr:[" + responseData + "]");
                if (null == responseData) {
                    throw new ResponseException(responseData);
                }
                String status = responseData.getString(Constants.STATUS);
                if (Constants.ERROR.equals(status)) {
                    throw new ResponseException(responseData);
                }
                this.bothVerifyHmacOrder(responseData);
                if (Constants.SUCCESS.equals(status)) {
                    resultListener.success(responseData);
                    break block6;
                }
                if (Constants.FAILED.equals(status)) {
                    resultListener.failure(responseData);
                    break block6;
                }
                throw new ResponseException(responseData);
            }
            catch (Exception e) {
                LOGGER.error("bothDelete error", (Throwable)e);
                throw new UnknownException(e);
            }
        }
    }

    public void bothBillQuery(BillQueryBuilder builder, ResultListener resultListener) {
        block6: {
            try {
                JSONObject requestData = builder.bothEncryptBuild();
                LOGGER.debug("bothBillQuery requestData:[" + requestData.toJSONString() + "]");
                String responseStr = HttpClientUtils.post3(ConfigurationUtils.getWeboxBillQueryUrl(), requestData);
                LOGGER.info("bothBillQuery responseStr:[" + responseStr + "]");
                JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
                responseData = CipherWrapper.bothDecryptWrap(responseData);
                LOGGER.info("responseStr:[" + responseData + "]");
                if (null == responseData) {
                    throw new ResponseException(responseData);
                }
                String status = responseData.getString(Constants.STATUS);
                if (Constants.ERROR.equals(status)) {
                    throw new ResponseException(responseData);
                }
                this.bothVerifyHmacOrder(responseData);
                if (Constants.SUCCESS.equals(status)) {
                    resultListener.success(responseData);
                    break block6;
                }
                if (Constants.FAILED.equals(status)) {
                    resultListener.failure(responseData);
                    break block6;
                }
                throw new ResponseException(responseData);
            }
            catch (Exception e) {
                LOGGER.error("bothBillQuery error", (Throwable)e);
                throw new UnknownException(e);
            }
        }
    }

    public void bothDetailQuery(BillDetailQueryBuilder builder, ResultListener resultListener) {
        block6: {
            try {
                JSONObject requestData = builder.bothEncryptBuild();
                LOGGER.debug("bothDetailQuery requestData:[" + requestData.toJSONString() + "]");
                String responseStr = HttpClientUtils.post3(ConfigurationUtils.getWeboxBillDetailQueryUrl(), requestData);
                LOGGER.info("bothDetailQuery responseStr:[" + responseStr + "]");
                JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
                responseData = CipherWrapper.bothDecryptWrap(responseData);
                LOGGER.info("responseStr:[" + responseData + "]");
                if (null == responseData) {
                    throw new ResponseException(responseData);
                }
                String status = responseData.getString(Constants.STATUS);
                if (Constants.ERROR.equals(status)) {
                    throw new ResponseException(responseData);
                }
                this.bothVerifyHmacOrder(responseData);
                if (Constants.SUCCESS.equals(status)) {
                    resultListener.success(responseData);
                    break block6;
                }
                if (Constants.FAILED.equals(status)) {
                    resultListener.failure(responseData);
                    break block6;
                }
                throw new ResponseException(responseData);
            }
            catch (Exception e) {
                LOGGER.error("bothDetailQuery error", (Throwable)e);
                throw new UnknownException(e);
            }
        }
    }

    public void bothRedPacketQuery(RedPacketBillQueryBuilder builder, ResultListener resultListener) {
        block6: {
            try {
                JSONObject requestData = builder.bothEncryptBuild();
                LOGGER.debug("bothRedpacketQuery requestData:[" + requestData.toJSONString() + "]");
                String responseStr = HttpClientUtils.post3(ConfigurationUtils.getWeboxRedPacketBillQueryUrl(), requestData);
                LOGGER.info("bothRedpacketQuery responseStr:[" + responseStr + "]");
                JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
                responseData = CipherWrapper.bothDecryptWrap(responseData);
                LOGGER.info("responseStr:[" + responseData + "]");
                if (null == responseData) {
                    throw new ResponseException(responseData);
                }
                String status = responseData.getString(Constants.STATUS);
                if (Constants.ERROR.equals(status)) {
                    throw new ResponseException(responseData);
                }
                this.bothVerifyHmacOrder(responseData);
                if (Constants.SUCCESS.equals(status)) {
                    resultListener.success(responseData);
                    break block6;
                }
                if (Constants.FAILED.equals(status)) {
                    resultListener.failure(responseData);
                    break block6;
                }
                throw new ResponseException(responseData);
            }
            catch (Exception e) {
                LOGGER.error("bothRedpacketQuery error", (Throwable)e);
                throw new UnknownException(e);
            }
        }
    }
}

