/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.webox.executer;

import com.alibaba.fastjson.JSONObject;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.Constants;
import com.upay.sdk.HttpClientUtils;
import com.upay.sdk.core.CipherWrapper;
import com.upay.sdk.core.response.HttpReponse;
import com.upay.sdk.exception.RequestParamException;
import com.upay.sdk.exception.ResponseDecryptException;
import com.upay.sdk.exception.UnknownException;
import com.upay.sdk.executer.Executer;
import com.upay.sdk.executer.ResultListener;
import com.upay.sdk.webox.builder.ConnectPayCreateBuilder;
import com.upay.sdk.webox.builder.ConnectPayQueryBuilder;
import com.upay.sdk.webox.builder.ConnectPaySubmitBuilder;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectPayExecuter
extends Executer {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectPayExecuter.class);

    public void create(ConnectPayCreateBuilder builder, ResultListener resultListener) throws RequestParamException, ResponseDecryptException {
        String url = ConfigurationUtils.getWeboxConnectPayCreateUrl();
        try {
            HttpReponse response = HttpClientUtils.sdkPost(url, builder);
            Object decryptResponse = response.getDecryptResponse();
            if (!(decryptResponse instanceof JSONObject)) {
                throw new RuntimeException("server response error,response object not a json!");
            }
            JSONObject responseJson = (JSONObject)decryptResponse;
            if (response.success()) {
                String status = responseJson.getString(Constants.STATUS);
                if (StringUtils.isBlank((CharSequence)status) || Constants.SUCCESS.equals(status)) {
                    resultListener.success(responseJson);
                } else {
                    resultListener.failure(responseJson);
                }
            } else {
                LOGGER.error("create request response error,errorCode:{}", (Object)response.getResponseCode());
                resultListener.failure(responseJson);
            }
        }
        catch (RequestParamException e) {
            LOGGER.error("create request url:[{}]", (Object)url, (Object)e);
            throw e;
        }
        catch (ResponseDecryptException e) {
            LOGGER.error("create request url:[{}] ", (Object)url, (Object)e);
            throw e;
        }
        catch (Exception e) {
            LOGGER.error("create request url:[{}]", (Object)url, (Object)e);
            throw new UnknownException(e);
        }
    }

    public void submit(ConnectPaySubmitBuilder builder, ResultListener resultListener) throws RequestParamException, ResponseDecryptException {
        String url = ConfigurationUtils.getWeboxConnectPaySubmitUrl();
        try {
            HttpReponse response = HttpClientUtils.sdkPost(url, builder);
            Object decryptResponse = response.getDecryptResponse();
            if (!(decryptResponse instanceof JSONObject)) {
                throw new RuntimeException("server response error,response object not a json!");
            }
            JSONObject responseJson = (JSONObject)decryptResponse;
            if (response.success()) {
                String status = responseJson.getString(Constants.STATUS);
                if (StringUtils.isBlank((CharSequence)status) || Constants.SUCCESS.equals(status)) {
                    resultListener.success(responseJson);
                } else {
                    resultListener.failure(responseJson);
                }
            } else {
                LOGGER.error("submit request response error,errorCode:{}", (Object)response.getResponseCode());
                resultListener.failure(responseJson);
            }
        }
        catch (RequestParamException e) {
            LOGGER.error("submit request url:[{}]", (Object)url, (Object)e);
            throw e;
        }
        catch (ResponseDecryptException e) {
            LOGGER.error("submit request url:[{}] ", (Object)url, (Object)e);
            throw e;
        }
        catch (Exception e) {
            LOGGER.error("submit request url:[{}]", (Object)url, (Object)e);
            throw new UnknownException(e);
        }
    }

    public void query(ConnectPayQueryBuilder builder, ResultListener resultListener) throws RequestParamException, ResponseDecryptException {
        String url = ConfigurationUtils.getWeboxConnectPayQureyUrl();
        try {
            HttpReponse response = HttpClientUtils.sdkPost(url, builder);
            Object decryptResponse = response.getDecryptResponse();
            if (!(decryptResponse instanceof JSONObject)) {
                throw new RuntimeException("server response error,response object not a json!");
            }
            JSONObject responseJson = (JSONObject)decryptResponse;
            if (response.success()) {
                String status = responseJson.getString(Constants.STATUS);
                if (StringUtils.isBlank((CharSequence)status) || Constants.SUCCESS.equals(status)) {
                    resultListener.success(responseJson);
                } else {
                    resultListener.failure(responseJson);
                }
            } else {
                LOGGER.error("query request response error,errorCode:{}", (Object)response.getResponseCode());
                resultListener.failure(responseJson);
            }
        }
        catch (RequestParamException e) {
            LOGGER.error("query request url:[{}]", (Object)url, (Object)e);
            throw e;
        }
        catch (ResponseDecryptException e) {
            LOGGER.error("query request url:[{}] ", (Object)url, (Object)e);
            throw e;
        }
        catch (Exception e) {
            LOGGER.error("query request url:[{}]", (Object)url, (Object)e);
            throw new UnknownException(e);
        }
    }

    public void callback(JSONObject responseData, ResultListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        JSONObject data = CipherWrapper.bothDecryptWrap(responseData);
        if (data == null) {
            throw new NullPointerException();
        }
        this.bothVerifyHmacOrder(data);
        listener.success(data);
    }
}

