/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.webox.builder;

import com.alibaba.fastjson.JSONObject;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.RSAUtils;
import com.upay.sdk.SignUtils;
import com.upay.sdk.builder.BuilderSupport;
import com.upay.sdk.core.CipherWrapper;
import com.upay.sdk.exception.UnknownException;

public class WithholdingBuilder
extends BuilderSupport {
    private String merchantId;
    private String bindCardId;
    private String subMerchantId;
    private String cashierBindCardId;
    private String requestId;
    private String walletId;
    private String amount;
    private String arrivalAmount;
    private String currency;
    private String notifyUrl;
    private String callbackUrl;
    private String returnBackNotifyUrl;
    private String wakeUpModel;
    private String timeout;
    private String remark;
    private String payAuthType;
    private String bankCardNumber;

    public WithholdingBuilder(String merchantId) {
        this.merchantId = merchantId;
    }

    public WithholdingBuilder setMerchantId(String merchantId) {
        this.merchantId = merchantId;
        return this;
    }

    public WithholdingBuilder setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public WithholdingBuilder setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
        return this;
    }

    public WithholdingBuilder setWalletId(String walletId) {
        this.walletId = walletId;
        return this;
    }

    public WithholdingBuilder setAmount(String amount) {
        this.amount = amount;
        return this;
    }

    public WithholdingBuilder setArrivalAmount(String arrivalAmount) {
        this.arrivalAmount = arrivalAmount;
        return this;
    }

    public WithholdingBuilder setCurrency(String currency) {
        this.currency = currency;
        return this;
    }

    public WithholdingBuilder setCallbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
        return this;
    }

    public WithholdingBuilder setWakeUpModel(String wakeUpModel) {
        this.wakeUpModel = wakeUpModel;
        return this;
    }

    public WithholdingBuilder setTimeout(String timeout) {
        this.timeout = timeout;
        return this;
    }

    public WithholdingBuilder setRemark(String remark) {
        this.remark = remark;
        return this;
    }

    public WithholdingBuilder setReturnBackNotifyUrl(String returnBackNotifyUrl) {
        this.returnBackNotifyUrl = returnBackNotifyUrl;
        return this;
    }

    public WithholdingBuilder setSubMerchantId(String subMerchantId) {
        this.subMerchantId = subMerchantId;
        return this;
    }

    public WithholdingBuilder setBindCardId(String bindCardId) {
        this.bindCardId = bindCardId;
        return this;
    }

    public WithholdingBuilder setPayAuthType(String payAuthType) {
        this.payAuthType = payAuthType;
        return this;
    }

    public WithholdingBuilder setBankCardNumber(String bankCardNumber) {
        this.bankCardNumber = bankCardNumber;
        return this;
    }

    public WithholdingBuilder setCashierBindCardId(String cashierBindCardId) {
        this.cashierBindCardId = cashierBindCardId;
        return this;
    }

    public JSONObject encryptBuild() {
        JSONObject json = super.assembleBuild();
        json.put("hmac", (Object)this.orderGenerateHmac());
        return CipherWrapper.encryptWrap(this.merchantId, json);
    }

    @Override
    protected String orderGenerateHmac() {
        String orderGenerateHmac = super.orderGenerateHmac();
        return SignUtils.signMd5(orderGenerateHmac, ConfigurationUtils.getHmacKey(this.merchantId));
    }

    public JSONObject bothEncryptBuild() {
        JSONObject json = super.assembleBuild();
        try {
            json.put("hmac", (Object)this.bothOrderGenerateHmac());
        }
        catch (Exception e) {
            throw new UnknownException(e);
        }
        return CipherWrapper.bothEncryptWrap(this.merchantId, json);
    }

    protected byte[] bothOrderGenerateHmac() throws Exception {
        return RSAUtils.encryptSHA(super.orderGenerateHmac().getBytes("UTF-8"));
    }
}

