/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.webox.builder;

import com.alibaba.fastjson.JSONObject;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.RSAUtils;
import com.upay.sdk.SignUtils;
import com.upay.sdk.builder.BuilderSupport;
import com.upay.sdk.core.CipherWrapper;
import com.upay.sdk.exception.UnknownException;

public class WalletUpdateIdCardPicBuilder
extends BuilderSupport {
    private String requestId;
    private String merchantId;
    private String walletId;
    private String idCardFrontPath;
    private String idCardBackPath;
    private String sex;
    private String nation;
    private String address;
    private String issue;
    private String period;

    public WalletUpdateIdCardPicBuilder(String merchantId) {
        this.merchantId = merchantId;
    }

    public WalletUpdateIdCardPicBuilder setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public WalletUpdateIdCardPicBuilder setMerchantId(String merchantId) {
        this.merchantId = merchantId;
        return this;
    }

    public WalletUpdateIdCardPicBuilder setWalletId(String walletId) {
        this.walletId = walletId;
        return this;
    }

    public WalletUpdateIdCardPicBuilder setIdCardFrontPath(String idCardFrontPath) {
        this.idCardFrontPath = idCardFrontPath;
        return this;
    }

    public WalletUpdateIdCardPicBuilder setIdCardBackPath(String idCardBackPath) {
        this.idCardBackPath = idCardBackPath;
        return this;
    }

    public WalletUpdateIdCardPicBuilder setSex(String sex) {
        this.sex = sex;
        return this;
    }

    public WalletUpdateIdCardPicBuilder setNation(String nation) {
        this.nation = nation;
        return this;
    }

    public WalletUpdateIdCardPicBuilder setAddress(String address) {
        this.address = address;
        return this;
    }

    public WalletUpdateIdCardPicBuilder setIssue(String issue) {
        this.issue = issue;
        return this;
    }

    public WalletUpdateIdCardPicBuilder setPeriod(String period) {
        this.period = period;
        return this;
    }

    public JSONObject encryptBuild() {
        JSONObject json = super.assembleBuild();
        json.put("hmac", (Object)this.orderGenerateHmac());
        return CipherWrapper.encryptWrap(this.merchantId, json);
    }

    @Override
    protected String orderGenerateHmac() {
        String orderGenerateHmac = super.orderGenerateHmac();
        return SignUtils.signMd5(orderGenerateHmac, ConfigurationUtils.getHmacKey(this.merchantId));
    }

    public JSONObject bothEncryptBuild() {
        JSONObject json = super.assembleBuild();
        try {
            json.put("hmac", (Object)this.bothOrderGenerateHmac());
        }
        catch (Exception e) {
            throw new UnknownException(e);
        }
        return CipherWrapper.bothEncryptWrap(this.merchantId, json);
    }

    protected byte[] bothOrderGenerateHmac() throws Exception {
        return RSAUtils.encryptSHA(super.orderGenerateHmac().getBytes("UTF-8"));
    }
}

