/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.webox.builder;

import com.alibaba.fastjson.JSONObject;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.RSAUtils;
import com.upay.sdk.SignUtils;
import com.upay.sdk.builder.BuilderSupport;
import com.upay.sdk.core.CipherWrapper;
import com.upay.sdk.exception.UnknownException;

public class WalletStatusModifyBuilder
extends BuilderSupport {
    private String walletId;
    private String walletStatus;
    private String remark;
    private String requestId;
    private String merchantId;

    public WalletStatusModifyBuilder(String merchantId) {
        this.merchantId = merchantId;
    }

    public WalletStatusModifyBuilder setMerchantId(String merchantId) {
        this.merchantId = merchantId;
        return this;
    }

    public WalletStatusModifyBuilder setWalletId(String walletId) {
        this.walletId = walletId;
        return this;
    }

    public WalletStatusModifyBuilder setWalletStatus(String walletStatus) {
        this.walletStatus = walletStatus;
        return this;
    }

    public WalletStatusModifyBuilder setRemark(String remark) {
        this.remark = remark;
        return this;
    }

    public WalletStatusModifyBuilder setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public JSONObject encryptBuild() {
        JSONObject json = super.assembleBuild();
        json.put("hmac", (Object)this.orderGenerateHmac());
        return CipherWrapper.encryptWrap(this.merchantId, json);
    }

    @Override
    protected String orderGenerateHmac() {
        String orderGenerateHmac = super.orderGenerateHmac();
        return SignUtils.signMd5(orderGenerateHmac, ConfigurationUtils.getHmacKey(this.merchantId));
    }

    public JSONObject bothEncryptBuild() {
        JSONObject json = super.assembleBuild();
        try {
            json.put("hmac", (Object)this.bothOrderGenerateHmac());
        }
        catch (Exception e) {
            throw new UnknownException(e);
        }
        return CipherWrapper.bothEncryptWrap(this.merchantId, json);
    }

    protected byte[] bothOrderGenerateHmac() throws Exception {
        return RSAUtils.encryptSHA(super.orderGenerateHmac().getBytes("UTF-8"));
    }
}

