/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.transferDomestic.builder;

import com.alibaba.fastjson.JSONObject;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.RSAUtils;
import com.upay.sdk.SignUtils;
import com.upay.sdk.builder.BuilderSupport;
import com.upay.sdk.core.CipherWrapper;
import com.upay.sdk.entity.TransferDomesticBatchPayee;
import com.upay.sdk.exception.UnknownException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class BatchOrderBuilder
extends BuilderSupport {
    private String merchantId;
    private String requestId;
    private String currency;
    private String amount;
    private String transferMode;
    private String notifyUrl;
    private String callbackUrl;
    private String remark;
    private String partnerId;
    private List<TransferDomesticBatchPayee> payees = new ArrayList<TransferDomesticBatchPayee>();

    public BatchOrderBuilder(String merchantId) {
        this.merchantId = merchantId;
    }

    public BatchOrderBuilder setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public BatchOrderBuilder setAmount(String amount) {
        this.amount = amount;
        return this;
    }

    public BatchOrderBuilder setCurrency(String currency) {
        this.currency = currency;
        return this;
    }

    public BatchOrderBuilder setTransferMode(String transferMode) {
        this.transferMode = transferMode;
        return this;
    }

    public BatchOrderBuilder setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
        return this;
    }

    public BatchOrderBuilder setCallbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
        return this;
    }

    public BatchOrderBuilder setRemark(String remark) {
        this.remark = remark;
        return this;
    }

    public String getPartnerId() {
        return this.partnerId;
    }

    public BatchOrderBuilder setPartnerId(String partnerId) {
        this.partnerId = partnerId;
        return this;
    }

    public BatchOrderBuilder setTransferDomesticBatchPayees(TransferDomesticBatchPayee transferDomesticBatchPayee) {
        this.payees.add(transferDomesticBatchPayee);
        return this;
    }

    public JSONObject build() {
        JSONObject json = super.build(this.merchantId);
        if (StringUtils.isNotBlank((CharSequence)this.requestId)) {
            json.put("requestId", (Object)this.requestId);
        }
        if (StringUtils.isNotBlank((CharSequence)this.amount)) {
            json.put("amount", (Object)this.amount);
        }
        if (StringUtils.isNotBlank((CharSequence)this.currency)) {
            json.put("currency", (Object)this.currency);
        }
        if (StringUtils.isNotBlank((CharSequence)this.transferMode)) {
            json.put("transferMode", (Object)this.transferMode);
        }
        if (StringUtils.isNotBlank((CharSequence)this.notifyUrl)) {
            json.put("notifyUrl", (Object)this.notifyUrl);
        }
        if (StringUtils.isNotBlank((CharSequence)this.callbackUrl)) {
            json.put("callbackUrl", (Object)this.callbackUrl);
        }
        if (StringUtils.isNotBlank((CharSequence)this.remark)) {
            json.put("remark", (Object)this.remark);
        }
        json.put("hmac", (Object)this.generateHmac());
        return json;
    }

    private String generateHmac() {
        StringBuilder hmacSource = new StringBuilder();
        hmacSource.append(StringUtils.defaultString((String)this.merchantId)).append(StringUtils.defaultString((String)this.requestId)).append((String)ObjectUtils.defaultIfNull((Object)this.amount, (Object)"")).append(StringUtils.defaultString((String)this.currency, (String)"")).append(StringUtils.defaultString((String)this.transferMode, (String)"")).append(StringUtils.defaultString((String)this.notifyUrl, (String)"")).append(StringUtils.defaultString((String)this.callbackUrl, (String)"")).append(StringUtils.defaultString((String)this.remark, (String)""));
        if (this.payees != null && !this.payees.isEmpty()) {
            for (TransferDomesticBatchPayee transferDomesticBatchPayee : this.payees) {
                hmacSource.append(StringUtils.defaultString((String)transferDomesticBatchPayee.getDetailRequestId())).append(StringUtils.defaultString((String)transferDomesticBatchPayee.getName())).append(StringUtils.defaultString((String)transferDomesticBatchPayee.getBankCardNum())).append(StringUtils.defaultString((String)transferDomesticBatchPayee.getBankName())).append(ObjectUtils.defaultIfNull((Object)transferDomesticBatchPayee.getDetailAmount(), (Object)"")).append(StringUtils.defaultString((String)transferDomesticBatchPayee.getBranchBankName())).append(StringUtils.defaultString((String)transferDomesticBatchPayee.getDetailRemark()));
            }
        }
        return SignUtils.signMd5(hmacSource.toString(), ConfigurationUtils.getHmacKey(this.merchantId));
    }

    public JSONObject encryptBuild() {
        JSONObject json = super.assembleBuild();
        System.out.println("transferDomestic builder sdk \u7b7e\u540d :" + super.orderGenerateHmac());
        json.put("hmac", (Object)this.orderGenerateHmac());
        if (StringUtils.isNotBlank((CharSequence)this.partnerId)) {
            return CipherWrapper.bothEncryptWrap(this.merchantId, this.partnerId, json);
        }
        return CipherWrapper.encryptWrap(this.merchantId, json);
    }

    @Override
    protected String orderGenerateHmac() {
        return SignUtils.signMd5(super.orderGenerateHmac(), ConfigurationUtils.getHmacKey(this.merchantId));
    }

    public JSONObject bothEncryptBuild() {
        JSONObject json = this.assembleBuild();
        try {
            json.put("hmac", (Object)this.bothOrderGenerateHmac());
        }
        catch (Exception e) {
            throw new UnknownException(e);
        }
        if (StringUtils.isNotBlank((CharSequence)this.partnerId)) {
            return CipherWrapper.bothEncryptWrap(this.merchantId, this.partnerId, json);
        }
        return CipherWrapper.bothEncryptWrap(this.merchantId, json);
    }

    protected byte[] bothOrderGenerateHmac() throws Exception {
        return RSAUtils.encryptSHA(super.orderGenerateHmac().getBytes("UTF-8"));
    }
}

