/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.serviceprovider.v3_0.report.builder;

import com.alibaba.fastjson.JSONObject;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.RSAUtils;
import com.upay.sdk.SignUtils;
import com.upay.sdk.builder.BuilderSupport;
import com.upay.sdk.core.CipherWrapper;
import com.upay.sdk.exception.UnknownException;
import org.apache.commons.lang3.StringUtils;

public class WeChatApiReportBuilder
extends BuilderSupport {
    private String partnerId;
    private String merchantId;
    private String requestId;
    private String channelType;
    private String distributorNo;
    private String merchantShortName;
    private String servicePhone;
    private String contact;
    private String contactPhone;
    private String contactEmail;
    private String merchantRemark;
    private String mcc;

    public WeChatApiReportBuilder(String merchantId) {
        this.merchantId = merchantId;
    }

    @Override
    protected String orderGenerateHmac() {
        return SignUtils.signMd5(super.orderGenerateHmac(), ConfigurationUtils.getHmacKey(this.merchantId));
    }

    public JSONObject encryptBuild() {
        JSONObject json = super.assembleBuild();
        json.put("hmac", (Object)this.orderGenerateHmac());
        if (StringUtils.isNotBlank((CharSequence)this.partnerId)) {
            return CipherWrapper.bothEncryptWrap(this.merchantId, this.partnerId, json);
        }
        return CipherWrapper.encryptWrap(this.merchantId, json);
    }

    public JSONObject bothEncryptBuild() {
        JSONObject json = super.assembleBuild();
        try {
            json.put("hmac", (Object)this.bothOrderGenerateHmac());
        }
        catch (Exception e) {
            throw new UnknownException(e);
        }
        if (StringUtils.isNotBlank((CharSequence)this.partnerId)) {
            return CipherWrapper.bothEncryptWrap(this.merchantId, this.partnerId, json);
        }
        return CipherWrapper.bothEncryptWrap(this.merchantId, json);
    }

    protected byte[] bothOrderGenerateHmac() throws Exception {
        return RSAUtils.encryptSHA(super.orderGenerateHmac().getBytes("UTF-8"));
    }

    public WeChatApiReportBuilder setPartnerId(String partnerId) {
        this.partnerId = partnerId;
        return this;
    }

    public WeChatApiReportBuilder setMerchantId(String merchantId) {
        this.merchantId = merchantId;
        return this;
    }

    public WeChatApiReportBuilder setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public WeChatApiReportBuilder setChannelType(String channelType) {
        this.channelType = channelType;
        return this;
    }

    public WeChatApiReportBuilder setDistributorNo(String distributorNo) {
        this.distributorNo = distributorNo;
        return this;
    }

    public WeChatApiReportBuilder setMerchantShortName(String merchantShortName) {
        this.merchantShortName = merchantShortName;
        return this;
    }

    public WeChatApiReportBuilder setServicePhone(String servicePhone) {
        this.servicePhone = servicePhone;
        return this;
    }

    public WeChatApiReportBuilder setContact(String contact) {
        this.contact = contact;
        return this;
    }

    public WeChatApiReportBuilder setContactPhone(String contactPhone) {
        this.contactPhone = contactPhone;
        return this;
    }

    public WeChatApiReportBuilder setContactEmail(String contactEmail) {
        this.contactEmail = contactEmail;
        return this;
    }

    public WeChatApiReportBuilder setMerchantRemark(String merchantRemark) {
        this.merchantRemark = merchantRemark;
        return this;
    }

    public WeChatApiReportBuilder setMcc(String mcc) {
        this.mcc = mcc;
        return this;
    }

    public String getPartnerId() {
        return this.partnerId;
    }

    public String getMerchantId() {
        return this.merchantId;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public String getChannelType() {
        return this.channelType;
    }

    public String getDistributorNo() {
        return this.distributorNo;
    }

    public String getMerchantShortName() {
        return this.merchantShortName;
    }

    public String getServicePhone() {
        return this.servicePhone;
    }

    public String getContact() {
        return this.contact;
    }

    public String getContactPhone() {
        return this.contactPhone;
    }

    public String getContactEmail() {
        return this.contactEmail;
    }

    public String getMerchantRemark() {
        return this.merchantRemark;
    }

    public String getMcc() {
        return this.mcc;
    }
}

