/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.serviceprovider.v3_0.declaration.executer;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.Constants;
import com.upay.sdk.HttpClientUtils;
import com.upay.sdk.core.CipherWrapper;
import com.upay.sdk.exception.ResponseException;
import com.upay.sdk.exception.UnknownException;
import com.upay.sdk.executer.Executer;
import com.upay.sdk.executer.ResultListener;
import com.upay.sdk.serviceprovider.v3_0.declaration.builder.QueryOpenAccountIntendConfirmApplyStatusBuilder;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryOpenAccountIntendConfirmApplyStatusExecuter
extends Executer {
    static final Logger LOGGER = LoggerFactory.getLogger(QueryOpenAccountIntendConfirmApplyStatusExecuter.class);

    public void declare(QueryOpenAccountIntendConfirmApplyStatusBuilder builder, ResultListener resultListener) {
        block5: {
            try {
                JSONObject requestData = builder.bothEncryptBuild();
                LOGGER.debug("QueryOpenAccountIntendConfirmApplyStatusExecuter requestData:[" + requestData.toJSONString() + "]");
                String serviceProviderQueryApplyStatusUrl = ConfigurationUtils.getServiceProviderQueryApplyStatusUrl();
                LOGGER.info("QueryOpenAccountIntendConfirmApplyStatusExecuter url:[" + serviceProviderQueryApplyStatusUrl + "]");
                String responseStr = HttpClientUtils.post3(serviceProviderQueryApplyStatusUrl, requestData);
                LOGGER.info("QueryOpenAccountIntendConfirmApplyStatusExecuter responseStr:[" + responseStr + "]");
                JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
                responseData = CipherWrapper.bothDecryptWrap(responseData);
                LOGGER.info("QueryOpenAccountIntendConfirmApplyStatusExecuter responseData:[" + responseData + "]");
                String status = responseData.getString(Constants.STATUS);
                if (Constants.ERROR.equals(status)) {
                    throw new ResponseException(responseData);
                }
                this.bothVerifyHmacOrder(responseData);
                if (Constants.SUCCESS.equals(status)) {
                    this.mapValue(responseData);
                    resultListener.success(responseData);
                    break block5;
                }
                if (Constants.FAILED.equals(status)) {
                    this.mapValue(responseData);
                    resultListener.failure(responseData);
                    break block5;
                }
                throw new ResponseException(responseData);
            }
            catch (Exception e) {
                LOGGER.error("QueryOpenAccountIntendConfirmApplyStatusExecuter error", (Throwable)e);
                throw new UnknownException(e);
            }
        }
    }

    private void mapValue(JSONObject jsonData) {
        String status = jsonData.getString("applyStatus");
        if (StringUtils.isNotBlank((CharSequence)status)) {
            for (Map.Entry entry : jsonData.entrySet()) {
                if ("AUDIT".equals(entry.getValue())) {
                    entry.setValue("\u5f85\u5ba1\u6838");
                }
                if ("FAILED".equals(entry.getValue())) {
                    entry.setValue("\u5931\u8d25");
                }
                if ("AUTHORIZE_STATE_AUTHORIZED".equals(entry.getValue())) {
                    entry.setValue("\u5df2\u6388\u6743");
                }
                if ("AUTHORIZE_STATE_UNAUTHORIZED".equals(entry.getValue())) {
                    entry.setValue("\u672a\u6388\u6743");
                }
                if ("SYS_UNDO".equals(entry.getValue())) {
                    entry.setValue("\u7cfb\u7edf\u64a4\u9500");
                }
                if (!"MERCHANT_UNDO".equals(entry.getValue())) continue;
                entry.setValue("\u5546\u6237\u64a4\u9500");
            }
        }
    }

    public void callBack(JSONObject responseData, ResultListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        LOGGER.info("QueryOpenAccountIntendConfirmApplyStatus callBack responseStr:[" + responseData + "]");
        JSONObject data = CipherWrapper.bothDecryptWrap(responseData);
        LOGGER.info("QueryOpenAccountIntendConfirmApplyStatus callBack responseData:[" + data + "]");
        this.bothVerifyHmacOrder(data);
        listener.success(data);
    }
}

