/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.serviceprovider.v3_0.declaration.builder;

import com.alibaba.fastjson.JSONObject;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.RSAUtils;
import com.upay.sdk.SignUtils;
import com.upay.sdk.builder.BuilderSupport;
import com.upay.sdk.core.CipherWrapper;
import com.upay.sdk.exception.UnknownException;
import com.upay.sdk.serviceprovider.v3_0.declaration.entity.MerchantInfoChangeBusinessInfo;
import com.upay.sdk.serviceprovider.v3_0.declaration.entity.MerchantInfoChangeContactInfo;
import com.upay.sdk.serviceprovider.v3_0.declaration.entity.MerchantInfoChangeLegalPersonInfo;
import com.upay.sdk.serviceprovider.v3_0.declaration.entity.MerchantInfoChangeSubjectInfo;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class MerchantInfoChangeBuilder
extends BuilderSupport {
    private String partnerId;
    private String merchantId;
    private String requestId;
    private String notifyUrl;
    private MerchantInfoChangeSubjectInfo merchantSubjectInfo;
    private MerchantInfoChangeBusinessInfo businessInfo;
    private MerchantInfoChangeLegalPersonInfo legalPersonInfo;
    private MerchantInfoChangeContactInfo contactInfo;

    @Override
    protected String orderGenerateHmac() {
        return SignUtils.signMd5(super.orderGenerateHmac(), ConfigurationUtils.getHmacKey(this.merchantId));
    }

    public JSONObject encryptBuild() {
        JSONObject json = super.assembleBuild();
        json.put("hmac", (Object)this.orderGenerateHmac());
        return CipherWrapper.encryptWrap(this.merchantId, json);
    }

    public JSONObject bothEncryptBuild() {
        JSONObject json = super.assembleBuild();
        try {
            json.put("hmac", (Object)this.bothOrderGenerateHmac());
        }
        catch (Exception e) {
            throw new UnknownException(e);
        }
        if (StringUtils.isNotBlank((CharSequence)this.partnerId)) {
            return CipherWrapper.bothEncryptWrap(this.merchantId, this.partnerId, json);
        }
        return CipherWrapper.bothEncryptWrap(this.merchantId, json);
    }

    protected byte[] bothOrderGenerateHmac() throws Exception {
        return RSAUtils.encryptSHA(super.orderGenerateHmac().getBytes("UTF-8"));
    }

    public String getPartnerId() {
        return this.partnerId;
    }

    public void setPartnerId(String partnerId) {
        this.partnerId = partnerId;
    }

    public String getMerchantId() {
        return this.merchantId;
    }

    public void setMerchantId(String merchantId) {
        this.merchantId = merchantId;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public String getNotifyUrl() {
        return this.notifyUrl;
    }

    public void setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
    }

    public MerchantInfoChangeSubjectInfo getMerchantSubjectInfo() {
        return this.merchantSubjectInfo;
    }

    public void setMerchantSubjectInfo(MerchantInfoChangeSubjectInfo merchantSubjectInfo) {
        this.merchantSubjectInfo = merchantSubjectInfo;
    }

    public MerchantInfoChangeBusinessInfo getBusinessInfo() {
        return this.businessInfo;
    }

    public void setBusinessInfo(MerchantInfoChangeBusinessInfo businessInfo) {
        this.businessInfo = businessInfo;
    }

    public MerchantInfoChangeLegalPersonInfo getLegalPersonInfo() {
        return this.legalPersonInfo;
    }

    public void setLegalPersonInfo(MerchantInfoChangeLegalPersonInfo legalPersonInfo) {
        this.legalPersonInfo = legalPersonInfo;
    }

    public MerchantInfoChangeContactInfo getContactInfo() {
        return this.contactInfo;
    }

    public void setContactInfo(MerchantInfoChangeContactInfo contactInfo) {
        this.contactInfo = contactInfo;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("requestId", (Object)this.requestId).append("notifyUrl", (Object)this.notifyUrl).append("merchantSubjectInfo", (Object)this.merchantSubjectInfo).append("businessInfo", (Object)this.businessInfo).append("legalPersonInfo", (Object)this.legalPersonInfo).append("contactInfo", (Object)this.contactInfo).toString();
    }
}

