/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.rz.builder;

import com.alibaba.fastjson.JSONObject;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.RSAUtils;
import com.upay.sdk.SignUtils;
import com.upay.sdk.builder.BuilderSupport;
import com.upay.sdk.core.CipherWrapper;
import com.upay.sdk.exception.UnknownException;
import org.apache.commons.lang3.StringUtils;

public final class RzOrderBuilder
extends BuilderSupport {
    private String merchantId;
    private String requestId;
    private String authType;
    private String name;
    private String idCardNum;
    private String bankCardNumber;
    private String phoneNumber;
    private String accountType;
    private String enterpriseOriginCode;
    private String enterpriseName;

    public RzOrderBuilder(String merchantId) {
        this.merchantId = merchantId;
    }

    public RzOrderBuilder setMerchantId(String merchantId) {
        this.merchantId = merchantId;
        return this;
    }

    public RzOrderBuilder setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public RzOrderBuilder setAuthType(String authType) {
        this.authType = authType;
        return this;
    }

    public RzOrderBuilder setName(String name) {
        this.name = name;
        return this;
    }

    public RzOrderBuilder setIdCardNum(String idCardNum) {
        this.idCardNum = idCardNum;
        return this;
    }

    public RzOrderBuilder setBankCardNumber(String bankCardNumber) {
        this.bankCardNumber = bankCardNumber;
        return this;
    }

    public RzOrderBuilder setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
        return this;
    }

    public RzOrderBuilder setAccountType(String accountType) {
        this.accountType = accountType;
        return this;
    }

    public RzOrderBuilder setEnterpriseOriginCode(String enterpriseOriginCode) {
        this.enterpriseOriginCode = enterpriseOriginCode;
        return this;
    }

    public RzOrderBuilder setEnterpriseName(String enterpriseName) {
        this.enterpriseName = enterpriseName;
        return this;
    }

    public JSONObject build() {
        JSONObject json = super.build(this.merchantId);
        if (StringUtils.isNotBlank((CharSequence)this.requestId)) {
            json.put("requestId", (Object)this.requestId);
        }
        if (StringUtils.isNotBlank((CharSequence)this.requestId)) {
            json.put("requestId", (Object)this.requestId);
        }
        if (StringUtils.isNotBlank((CharSequence)this.authType)) {
            json.put("authType", (Object)this.authType);
        }
        if (StringUtils.isNotBlank((CharSequence)this.name)) {
            json.put("name", (Object)this.name);
        }
        if (StringUtils.isNotBlank((CharSequence)this.idCardNum)) {
            json.put("idCardNum", (Object)this.idCardNum);
        }
        if (StringUtils.isNotBlank((CharSequence)this.bankCardNumber)) {
            json.put("bankCardNumber", (Object)this.bankCardNumber);
        }
        if (StringUtils.isNotBlank((CharSequence)this.phoneNumber)) {
            json.put("phoneNumber", (Object)this.phoneNumber);
        }
        json.put("hmac", (Object)this.generateHmac());
        return json;
    }

    private String generateHmac() {
        StringBuilder hmacSource = new StringBuilder();
        hmacSource.append(this.merchantId).append(this.requestId).append(this.authType).append(this.name).append(this.idCardNum).append(this.bankCardNumber).append(this.phoneNumber);
        return SignUtils.signMd5(hmacSource.toString(), ConfigurationUtils.getHmacKey(this.merchantId));
    }

    public JSONObject encryptBuild() {
        JSONObject json = super.assembleBuild();
        json.put("hmac", (Object)this.orderGenerateHmac());
        return CipherWrapper.encryptWrap(this.merchantId, json);
    }

    @Override
    protected String orderGenerateHmac() {
        return SignUtils.signMd5(super.orderGenerateHmac(), ConfigurationUtils.getHmacKey(this.merchantId));
    }

    public JSONObject bothEncryptBuild() {
        JSONObject json = super.assembleBuild();
        try {
            json.put("hmac", (Object)this.bothOrderGenerateHmac());
        }
        catch (Exception e) {
            throw new UnknownException(e);
        }
        return CipherWrapper.bothEncryptWrap(this.merchantId, json);
    }

    protected byte[] bothOrderGenerateHmac() throws Exception {
        return RSAUtils.encryptSHA(super.orderGenerateHmac().getBytes("UTF-8"));
    }
}

