/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.rz.builder;

import com.alibaba.fastjson.JSONObject;
import com.upay.sdk.RSAUtils;
import com.upay.sdk.builder.BuilderSupport;
import com.upay.sdk.core.CipherWrapper;
import com.upay.sdk.exception.UnknownException;

public final class RzAuthTransferBuilder
extends BuilderSupport {
    private String partnerId;
    private String merchantId;
    private String requestId;
    private String amount;
    private String currency;
    private String receiverAccName;
    private String receiverAccNo;
    private String creditCode;
    private String timeOut;
    private String notifyUrl;
    private String remark;

    public JSONObject bothEncryptBuild() {
        JSONObject json = super.assembleBuild();
        try {
            json.put("hmac", (Object)this.bothOrderGenerateHmac());
        }
        catch (Exception e) {
            throw new UnknownException(e);
        }
        if (this.partnerId != null) {
            return CipherWrapper.bothEncryptWrap(this.merchantId, this.partnerId, json);
        }
        return CipherWrapper.bothEncryptWrap(this.merchantId, json);
    }

    protected byte[] bothOrderGenerateHmac() throws Exception {
        return RSAUtils.encryptSHA(super.orderGenerateHmac().getBytes("UTF-8"));
    }

    RzAuthTransferBuilder(String partnerId, String merchantId, String requestId, String amount, String currency, String receiverAccName, String receiverAccNo, String creditCode, String timeOut, String notifyUrl, String remark) {
        this.partnerId = partnerId;
        this.merchantId = merchantId;
        this.requestId = requestId;
        this.amount = amount;
        this.currency = currency;
        this.receiverAccName = receiverAccName;
        this.receiverAccNo = receiverAccNo;
        this.creditCode = creditCode;
        this.timeOut = timeOut;
        this.notifyUrl = notifyUrl;
        this.remark = remark;
    }

    public static RzAuthTransferBuilderBuilder builder() {
        return new RzAuthTransferBuilderBuilder();
    }

    public String getPartnerId() {
        return this.partnerId;
    }

    public String getMerchantId() {
        return this.merchantId;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public String getAmount() {
        return this.amount;
    }

    public String getCurrency() {
        return this.currency;
    }

    public String getReceiverAccName() {
        return this.receiverAccName;
    }

    public String getReceiverAccNo() {
        return this.receiverAccNo;
    }

    public String getCreditCode() {
        return this.creditCode;
    }

    public String getTimeOut() {
        return this.timeOut;
    }

    public String getNotifyUrl() {
        return this.notifyUrl;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setPartnerId(String partnerId) {
        this.partnerId = partnerId;
    }

    public void setMerchantId(String merchantId) {
        this.merchantId = merchantId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public void setAmount(String amount) {
        this.amount = amount;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public void setReceiverAccName(String receiverAccName) {
        this.receiverAccName = receiverAccName;
    }

    public void setReceiverAccNo(String receiverAccNo) {
        this.receiverAccNo = receiverAccNo;
    }

    public void setCreditCode(String creditCode) {
        this.creditCode = creditCode;
    }

    public void setTimeOut(String timeOut) {
        this.timeOut = timeOut;
    }

    public void setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RzAuthTransferBuilder)) {
            return false;
        }
        RzAuthTransferBuilder other = (RzAuthTransferBuilder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$partnerId = this.getPartnerId();
        String other$partnerId = other.getPartnerId();
        if (this$partnerId == null ? other$partnerId != null : !this$partnerId.equals(other$partnerId)) {
            return false;
        }
        String this$merchantId = this.getMerchantId();
        String other$merchantId = other.getMerchantId();
        if (this$merchantId == null ? other$merchantId != null : !this$merchantId.equals(other$merchantId)) {
            return false;
        }
        String this$requestId = this.getRequestId();
        String other$requestId = other.getRequestId();
        if (this$requestId == null ? other$requestId != null : !this$requestId.equals(other$requestId)) {
            return false;
        }
        String this$amount = this.getAmount();
        String other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !this$amount.equals(other$amount)) {
            return false;
        }
        String this$currency = this.getCurrency();
        String other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
            return false;
        }
        String this$receiverAccName = this.getReceiverAccName();
        String other$receiverAccName = other.getReceiverAccName();
        if (this$receiverAccName == null ? other$receiverAccName != null : !this$receiverAccName.equals(other$receiverAccName)) {
            return false;
        }
        String this$receiverAccNo = this.getReceiverAccNo();
        String other$receiverAccNo = other.getReceiverAccNo();
        if (this$receiverAccNo == null ? other$receiverAccNo != null : !this$receiverAccNo.equals(other$receiverAccNo)) {
            return false;
        }
        String this$creditCode = this.getCreditCode();
        String other$creditCode = other.getCreditCode();
        if (this$creditCode == null ? other$creditCode != null : !this$creditCode.equals(other$creditCode)) {
            return false;
        }
        String this$timeOut = this.getTimeOut();
        String other$timeOut = other.getTimeOut();
        if (this$timeOut == null ? other$timeOut != null : !this$timeOut.equals(other$timeOut)) {
            return false;
        }
        String this$notifyUrl = this.getNotifyUrl();
        String other$notifyUrl = other.getNotifyUrl();
        if (this$notifyUrl == null ? other$notifyUrl != null : !this$notifyUrl.equals(other$notifyUrl)) {
            return false;
        }
        String this$remark = this.getRemark();
        String other$remark = other.getRemark();
        return !(this$remark == null ? other$remark != null : !this$remark.equals(other$remark));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RzAuthTransferBuilder;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $partnerId = this.getPartnerId();
        result = result * 59 + ($partnerId == null ? 43 : $partnerId.hashCode());
        String $merchantId = this.getMerchantId();
        result = result * 59 + ($merchantId == null ? 43 : $merchantId.hashCode());
        String $requestId = this.getRequestId();
        result = result * 59 + ($requestId == null ? 43 : $requestId.hashCode());
        String $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : $amount.hashCode());
        String $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        String $receiverAccName = this.getReceiverAccName();
        result = result * 59 + ($receiverAccName == null ? 43 : $receiverAccName.hashCode());
        String $receiverAccNo = this.getReceiverAccNo();
        result = result * 59 + ($receiverAccNo == null ? 43 : $receiverAccNo.hashCode());
        String $creditCode = this.getCreditCode();
        result = result * 59 + ($creditCode == null ? 43 : $creditCode.hashCode());
        String $timeOut = this.getTimeOut();
        result = result * 59 + ($timeOut == null ? 43 : $timeOut.hashCode());
        String $notifyUrl = this.getNotifyUrl();
        result = result * 59 + ($notifyUrl == null ? 43 : $notifyUrl.hashCode());
        String $remark = this.getRemark();
        result = result * 59 + ($remark == null ? 43 : $remark.hashCode());
        return result;
    }

    public String toString() {
        return "RzAuthTransferBuilder(partnerId=" + this.getPartnerId() + ", merchantId=" + this.getMerchantId() + ", requestId=" + this.getRequestId() + ", amount=" + this.getAmount() + ", currency=" + this.getCurrency() + ", receiverAccName=" + this.getReceiverAccName() + ", receiverAccNo=" + this.getReceiverAccNo() + ", creditCode=" + this.getCreditCode() + ", timeOut=" + this.getTimeOut() + ", notifyUrl=" + this.getNotifyUrl() + ", remark=" + this.getRemark() + ")";
    }

    public static class RzAuthTransferBuilderBuilder {
        private String partnerId;
        private String merchantId;
        private String requestId;
        private String amount;
        private String currency;
        private String receiverAccName;
        private String receiverAccNo;
        private String creditCode;
        private String timeOut;
        private String notifyUrl;
        private String remark;

        RzAuthTransferBuilderBuilder() {
        }

        public RzAuthTransferBuilderBuilder partnerId(String partnerId) {
            this.partnerId = partnerId;
            return this;
        }

        public RzAuthTransferBuilderBuilder merchantId(String merchantId) {
            this.merchantId = merchantId;
            return this;
        }

        public RzAuthTransferBuilderBuilder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public RzAuthTransferBuilderBuilder amount(String amount) {
            this.amount = amount;
            return this;
        }

        public RzAuthTransferBuilderBuilder currency(String currency) {
            this.currency = currency;
            return this;
        }

        public RzAuthTransferBuilderBuilder receiverAccName(String receiverAccName) {
            this.receiverAccName = receiverAccName;
            return this;
        }

        public RzAuthTransferBuilderBuilder receiverAccNo(String receiverAccNo) {
            this.receiverAccNo = receiverAccNo;
            return this;
        }

        public RzAuthTransferBuilderBuilder creditCode(String creditCode) {
            this.creditCode = creditCode;
            return this;
        }

        public RzAuthTransferBuilderBuilder timeOut(String timeOut) {
            this.timeOut = timeOut;
            return this;
        }

        public RzAuthTransferBuilderBuilder notifyUrl(String notifyUrl) {
            this.notifyUrl = notifyUrl;
            return this;
        }

        public RzAuthTransferBuilderBuilder remark(String remark) {
            this.remark = remark;
            return this;
        }

        public RzAuthTransferBuilder build() {
            return new RzAuthTransferBuilder(this.partnerId, this.merchantId, this.requestId, this.amount, this.currency, this.receiverAccName, this.receiverAccNo, this.creditCode, this.timeOut, this.notifyUrl, this.remark);
        }

        public String toString() {
            return "RzAuthTransferBuilder.RzAuthTransferBuilderBuilder(partnerId=" + this.partnerId + ", merchantId=" + this.merchantId + ", requestId=" + this.requestId + ", amount=" + this.amount + ", currency=" + this.currency + ", receiverAccName=" + this.receiverAccName + ", receiverAccNo=" + this.receiverAccNo + ", creditCode=" + this.creditCode + ", timeOut=" + this.timeOut + ", notifyUrl=" + this.notifyUrl + ", remark=" + this.remark + ")";
        }
    }
}

