/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.rz.builder;

import com.alibaba.fastjson.JSONObject;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.RSAUtils;
import com.upay.sdk.SignUtils;
import com.upay.sdk.builder.BuilderSupport;
import com.upay.sdk.core.CipherWrapper;
import com.upay.sdk.exception.UnknownException;
import org.apache.commons.lang3.StringUtils;

public class CreditQueryOrderBuilder
extends BuilderSupport {
    private String merchantId;
    private String requestId;
    private String creditType;
    private String userName;
    private String userIdNum;
    private String userType;
    private String enterpriseName;
    private String enterpriseIdNum;

    public CreditQueryOrderBuilder(String merchantId) {
        this.merchantId = merchantId;
    }

    public String getMerchantId() {
        return this.merchantId;
    }

    public CreditQueryOrderBuilder setMerchantId(String merchantId) {
        this.merchantId = merchantId;
        return this;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public CreditQueryOrderBuilder setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public String getCreditType() {
        return this.creditType;
    }

    public CreditQueryOrderBuilder setCreditType(String creditType) {
        this.creditType = creditType;
        return this;
    }

    public String getUserName() {
        return this.userName;
    }

    public CreditQueryOrderBuilder setUserName(String userName) {
        this.userName = userName;
        return this;
    }

    public String getUserIdNum() {
        return this.userIdNum;
    }

    public CreditQueryOrderBuilder setUserIdNum(String userIdNum) {
        this.userIdNum = userIdNum;
        return this;
    }

    public String getUserType() {
        return this.userType;
    }

    public CreditQueryOrderBuilder setUserType(String userType) {
        this.userType = userType;
        return this;
    }

    public String getEnterpriseName() {
        return this.enterpriseName;
    }

    public CreditQueryOrderBuilder setEnterpriseName(String enterpriseName) {
        this.enterpriseName = enterpriseName;
        return this;
    }

    public String getEnterpriseIdNum() {
        return this.enterpriseIdNum;
    }

    public CreditQueryOrderBuilder setEnterpriseIdNum(String enterpriseIdNum) {
        this.enterpriseIdNum = enterpriseIdNum;
        return this;
    }

    public JSONObject build() {
        JSONObject json = super.build(this.merchantId);
        if (StringUtils.isNotBlank((CharSequence)this.requestId)) {
            json.put("requestId", (Object)this.requestId);
        }
        if (StringUtils.isNotBlank((CharSequence)this.creditType)) {
            json.put("creditType", (Object)this.creditType);
        }
        if (StringUtils.isNotBlank((CharSequence)this.userName)) {
            json.put("userName", (Object)this.userName);
        }
        if (StringUtils.isNotBlank((CharSequence)this.userIdNum)) {
            json.put("userIdNum", (Object)this.userIdNum);
        }
        if (StringUtils.isNotBlank((CharSequence)this.userType)) {
            json.put("userType", (Object)this.userType);
        }
        if (StringUtils.isNotBlank((CharSequence)this.enterpriseName)) {
            json.put("enterpriseName", (Object)this.enterpriseName);
        }
        if (StringUtils.isNotBlank((CharSequence)this.enterpriseIdNum)) {
            json.put("enterpriseIdNum", (Object)this.enterpriseIdNum);
        }
        json.put("hmac", (Object)this.generateHmac());
        return json;
    }

    private String generateHmac() {
        StringBuilder hmacSource = new StringBuilder();
        hmacSource.append(this.merchantId).append(this.requestId).append(this.creditType).append(this.userName).append(this.userIdNum).append(this.userType).append(this.enterpriseName).append(this.enterpriseIdNum);
        return SignUtils.signMd5(hmacSource.toString(), ConfigurationUtils.getHmacKey(this.merchantId));
    }

    public JSONObject encryptBuild() {
        JSONObject json = super.assembleBuild();
        json.put("hmac", (Object)this.orderGenerateHmac());
        return CipherWrapper.encryptWrap(this.merchantId, json);
    }

    @Override
    protected String orderGenerateHmac() {
        return SignUtils.signMd5(super.orderGenerateHmac(), ConfigurationUtils.getHmacKey(this.merchantId));
    }

    public JSONObject bothEncryptBuild() {
        JSONObject json = super.assembleBuild();
        try {
            json.put("hmac", (Object)this.bothOrderGenerateHmac());
        }
        catch (Exception e) {
            throw new UnknownException(e);
        }
        return CipherWrapper.bothEncryptWrap(this.merchantId, json);
    }

    protected byte[] bothOrderGenerateHmac() throws Exception {
        return RSAUtils.encryptSHA(super.orderGenerateHmac().getBytes("UTF-8"));
    }
}

