/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.remittance.builder;

import com.alibaba.fastjson.JSONObject;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.RSAUtils;
import com.upay.sdk.SignUtils;
import com.upay.sdk.builder.BuilderSupport;
import com.upay.sdk.core.CipherWrapper;
import com.upay.sdk.exception.UnknownException;
import com.upay.sdk.remittance.builder.Payee;
import com.upay.sdk.remittance.builder.Payer;

public class RemittanceOrderBuilder
extends BuilderSupport {
    private String merchantId;
    private String requestId;
    private String currency;
    private String amount;
    private String notifyUrl;
    private String tradePostscript;
    private Payee payee;
    private Payer payer;
    private String sourceCountry;
    private String fundPurpose;

    public RemittanceOrderBuilder setSourceCountry(String sourceCountry) {
        this.sourceCountry = sourceCountry;
        return this;
    }

    public RemittanceOrderBuilder(String merchantId) {
        this.merchantId = merchantId;
    }

    public RemittanceOrderBuilder setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public RemittanceOrderBuilder setAmount(String amount) {
        this.amount = amount;
        return this;
    }

    public RemittanceOrderBuilder setCurrency(String currency) {
        this.currency = currency;
        return this;
    }

    public RemittanceOrderBuilder setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
        return this;
    }

    public RemittanceOrderBuilder setTradePostscript(String tradePostscript) {
        this.tradePostscript = tradePostscript;
        return this;
    }

    public RemittanceOrderBuilder setPayee(Payee payee) {
        this.payee = payee;
        return this;
    }

    public RemittanceOrderBuilder setPayer(Payer payer) {
        this.payer = payer;
        return this;
    }

    public RemittanceOrderBuilder setFundPurpose(String fundPurpose) {
        this.fundPurpose = fundPurpose;
        return this;
    }

    public JSONObject encryptBuild() {
        JSONObject json = super.assembleBuild();
        System.out.println("SingleOrderBuilder sdk \u7b7e\u540d :" + super.orderGenerateHmac());
        json.put("hmac", (Object)this.orderGenerateHmac());
        return CipherWrapper.encryptWrap(this.merchantId, json);
    }

    @Override
    protected String orderGenerateHmac() {
        return SignUtils.signMd5(super.orderGenerateHmac(), ConfigurationUtils.getHmacKey(this.merchantId));
    }

    public JSONObject bothEncryptBuild() {
        JSONObject json = this.assembleBuild();
        try {
            json.put("hmac", (Object)this.bothOrderGenerateHmac());
        }
        catch (Exception e) {
            throw new UnknownException(e);
        }
        return CipherWrapper.bothEncryptWrap(this.merchantId, json);
    }

    protected byte[] bothOrderGenerateHmac() throws Exception {
        return RSAUtils.encryptSHA(super.orderGenerateHmac().getBytes("UTF-8"));
    }
}

