/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.jointaccount.v_2.builder;

import com.alibaba.fastjson.JSONObject;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.SignUtils;
import com.upay.sdk.builder.BuilderSupport;
import com.upay.sdk.core.CipherWrapper;
import org.apache.commons.lang3.StringUtils;

public class QualificationUploadBuilder
extends BuilderSupport {
    private String merchantId;
    private String jointNumber;
    private String juridicalName;
    private String juridicalIdNum;
    private String juridicalBusinessId;
    private String contactsName;
    private String contactsPhone;
    private String contactsEmail;
    private String name;

    public QualificationUploadBuilder(String merchantId) {
        this.merchantId = merchantId;
    }

    public QualificationUploadBuilder setJointNumber(String jointNumber) {
        this.jointNumber = jointNumber;
        return this;
    }

    public QualificationUploadBuilder setJuridicalName(String juridicalName) {
        this.juridicalName = juridicalName;
        return this;
    }

    public QualificationUploadBuilder setJuridicalIdNum(String juridicalIdNum) {
        this.juridicalIdNum = juridicalIdNum;
        return this;
    }

    public QualificationUploadBuilder setJuridicalBusinessId(String juridicalBusinessId) {
        this.juridicalBusinessId = juridicalBusinessId;
        return this;
    }

    public QualificationUploadBuilder setContactsName(String contactsName) {
        this.contactsName = contactsName;
        return this;
    }

    public QualificationUploadBuilder setContactsPhone(String contactsPhone) {
        this.contactsPhone = contactsPhone;
        return this;
    }

    public QualificationUploadBuilder setContactsEmail(String contactsEmail) {
        this.contactsEmail = contactsEmail;
        return this;
    }

    public QualificationUploadBuilder setName(String name) {
        this.name = name;
        return this;
    }

    public JSONObject build() {
        JSONObject json = super.build(this.merchantId);
        if (StringUtils.isNotBlank((CharSequence)this.jointNumber)) {
            json.put("jointNumber", (Object)this.jointNumber);
        }
        if (StringUtils.isNotBlank((CharSequence)this.juridicalName)) {
            json.put("juridicalName", (Object)this.juridicalName);
        }
        if (StringUtils.isNotBlank((CharSequence)this.juridicalIdNum)) {
            json.put("juridicalIdNum", (Object)this.juridicalIdNum);
        }
        if (StringUtils.isNotBlank((CharSequence)this.juridicalBusinessId)) {
            json.put("juridicalBusinessId", (Object)this.juridicalBusinessId);
        }
        if (StringUtils.isNotBlank((CharSequence)this.contactsName)) {
            json.put("contactsName", (Object)this.contactsName);
        }
        if (StringUtils.isNotBlank((CharSequence)this.contactsPhone)) {
            json.put("contactsPhone", (Object)this.contactsPhone);
        }
        if (StringUtils.isNotBlank((CharSequence)this.contactsEmail)) {
            json.put("contactsEmail", (Object)this.contactsEmail);
        }
        if (StringUtils.isNotBlank((CharSequence)this.name)) {
            json.put("remark", (Object)this.name);
        }
        return json;
    }

    public JSONObject encryptBuild() {
        JSONObject json = super.assembleBuild();
        json.put("hmac", (Object)this.orderGenerateHmac());
        return CipherWrapper.encryptWrap(this.merchantId, json);
    }

    @Override
    protected String orderGenerateHmac() {
        String orderGenerateHmac = super.orderGenerateHmac();
        String hmacKey = ConfigurationUtils.getHmacKey(this.merchantId);
        return SignUtils.signMd5(orderGenerateHmac, hmacKey);
    }
}

