/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.hg.executer;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.Constants;
import com.upay.sdk.HttpClientUtils;
import com.upay.sdk.exception.ResponseException;
import com.upay.sdk.exception.UnknownException;
import com.upay.sdk.executer.Executer;
import com.upay.sdk.executer.HmacArray;
import com.upay.sdk.executer.ResultListener;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HgOrderExecuter
extends Executer {
    static final Logger LOGGER = LoggerFactory.getLogger(HgOrderExecuter.class);
    static final String[] ORDER_RESPONSE_HMAC_FIELDS = new String[]{Constants.MERCHANT_ID, Constants.REQUEST_ID, Constants.STATUS};
    static final Object[] QUERY_RESPONSE_HMAC_FIELDS = new Object[]{Constants.MERCHANT_ID, Constants.REQUEST_ID, HmacArray.create("customsInfos", new String[]{"customsChannel", "amount", "freight", "goodsAmount", "tax", "status"})};

    public void order(JSONObject requestData, ResultListener resultListener) {
        block4: {
            try {
                LOGGER.debug("requestData:[" + requestData.toJSONString() + "]");
                String responseStr = HttpClientUtils.post(ConfigurationUtils.getHgOrderUrl(), requestData.toJSONString());
                LOGGER.debug("responseStr:[" + responseStr + "]");
                JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
                this.verifyHmac(ORDER_RESPONSE_HMAC_FIELDS, responseData);
                if (Constants.REDIRECT.equals(responseData.getString(Constants.STATUS))) {
                    resultListener.redirect(responseData, responseData.getString("redirectUrl"));
                    break block4;
                }
                if (Constants.SUCCESS.equals(responseData.getString(Constants.STATUS))) {
                    resultListener.success(responseData);
                    break block4;
                }
                throw new ResponseException(responseData);
            }
            catch (IOException e) {
                LOGGER.error("request order exception", (Throwable)e);
                throw new UnknownException(e);
            }
        }
    }

    public void callback(JSONObject responseData, ResultListener paymentListener, ResultListener customsListener) {
        this.verifyHmac(QUERY_RESPONSE_HMAC_FIELDS, responseData);
        JSONArray array = responseData.getJSONArray("customsInfos");
        for (Object obj : array) {
            JSONObject hgJson = (JSONObject)obj;
            if (hgJson != null) {
                String status = hgJson.getString("status");
                if (Constants.SUCCESS.equals(status)) {
                    customsListener.success(hgJson);
                    continue;
                }
                if (Constants.PROCESSING.equals(status)) {
                    customsListener.processing(hgJson);
                    continue;
                }
                throw new ResponseException(responseData);
            }
            LOGGER.info("do nothing.", (Object)hgJson);
        }
    }

    public void query(JSONObject requestData, ResultListener paymentListener, ResultListener customsListener) {
        LOGGER.debug("requestData:[" + requestData.toJSONString() + "]");
        String responseStr = HttpClientUtils.post(ConfigurationUtils.getHgQueryUrl(), requestData.toJSONString());
        LOGGER.debug("responseStr:[" + responseStr + "]");
        JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
        this.callback(responseData, paymentListener, customsListener);
    }
}

